/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class ChequeDepositView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.chequeDeposit";
    private static Map<String, String> bankData = new HashMap<String, String>();
    private String selectedImagePath;
    private static final long MAX_IMAGE_SIZE = 0x200000L;
    NumberFormat nf = CorePlugin.getNumberFormatter();
    NumberFormat pf = CorePlugin.getPriceFormatter();
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Text txtClientCode;
    private Text txtAmount;
    private Combo bankDropdown;
    private String ChequeImage = null;
    private String selectedBankGlCode = null;
    private Text imagePathText;
    private Label remarksLabel;
    private Label lblClientCode;
    private Label lblbankName;
    private Label lblAmount;
    private Label lblNote1;
    private Label lblNote2;
    private Label lblNote3;
    private Button btnSubmit;
    private Button btnSend;
    Composite parent;
    private Log logger = LogFactory.getLog(this.getClass());
    final PriceVerifyListener numberVerifyListener = new PriceVerifyListener();

    public ChequeDepositView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
        this.BankDataRetriever();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        new Color((Device)parent.getDisplay(), 0, 0, 0);
        GridData txtGridData = new GridData(200, 15);
        GridData lblGridData = new GridData(100, 15);
        GridData btnGridData = new GridData(4, 4, true, false);
        GridData combGridData = new GridData(180, 15);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group mainGroup = new Group(composite, 16);
        mainGroup.setText("");
        mainGroup.setLayout((Layout)new GridLayout(2, true));
        mainGroup.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        Group clientDetails = new Group((Composite)mainGroup, 16);
        clientDetails.setText("Funds Deposit");
        clientDetails.setLayout((Layout)new GridLayout(2, true));
        clientDetails.setLayoutData((Object)new GridData(768, 1, false, false, 2, 1));
        clientDetails.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        Group noteLines = new Group(composite, 16);
        noteLines.setText("NOTE:");
        noteLines.setLayout((Layout)new GridLayout(1, true));
        noteLines.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        noteLines.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblNote1 = new Label((Composite)noteLines, 1);
        this.lblNote1.setText("* In case of a Cheque deposit; please upload one image having both the cheque and the deposit slip.");
        this.lblNote1.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblNote2 = new Label((Composite)noteLines, 1);
        this.lblNote2.setText("* In case of Online transfer; please upload a confirmation snapshot showing account title and reference number. ");
        this.lblNote2.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblNote3 = new Label((Composite)noteLines, 1);
        this.lblNote3.setText("* In case of Cash deposit; please upload the deposit slip however Cash Deposit of over Rs: 25,000/- is not acceptable.");
        this.lblNote3.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblClientCode = new Label((Composite)clientDetails, 1);
        this.lblClientCode.setLayoutData((Object)lblGridData);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text((Composite)clientDetails, 2048);
        this.txtClientCode.setLayoutData((Object)txtGridData);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChequeDepositView.this.buttonEnablement();
            }
        });
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                char cfr_ignored_0 = e.character;
            }
        });
        this.txtClientCode.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ChequeDepositView.this.txtClientCode.selectAll();
            }
        });
        this.lblAmount = new Label((Composite)clientDetails, 1);
        this.lblAmount.setLayoutData((Object)lblGridData);
        this.lblAmount.setText("Enter Amount");
        this.txtAmount = new Text((Composite)clientDetails, 2048);
        this.txtAmount.setLayoutData((Object)txtGridData);
        this.txtAmount.setEnabled(true);
        this.txtAmount.addVerifyListener((VerifyListener)this.numberVerifyListener);
        this.txtAmount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChequeDepositView.this.buttonEnablement();
            }
        });
        this.txtAmount.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                char cfr_ignored_0 = e.character;
            }
        });
        this.txtAmount.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ChequeDepositView.this.txtAmount.selectAll();
            }
        });
        this.lblbankName = new Label((Composite)clientDetails, 1);
        this.lblbankName.setLayoutData((Object)lblGridData);
        this.lblbankName.setText("Select Bank");
        this.bankDropdown = new Combo((Composite)clientDetails, 12);
        this.bankDropdown.setLayoutData((Object)combGridData);
        this.bankDropdown.setText("Select Bank");
        this.bankDropdown.setFocus();
        this.updateDropdown();
        this.bankDropdown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChequeDepositView.this.selectedBankGlCode = (String)bankData.get(ChequeDepositView.this.bankDropdown.getText());
                ChequeDepositView.this.logger.info((Object)("Selected GL Code: " + ChequeDepositView.this.selectedBankGlCode));
            }
        });
        Label imageLabel = new Label((Composite)clientDetails, 0);
        imageLabel.setText("Image:");
        this.imagePathText = new Text((Composite)clientDetails, 2056);
        this.imagePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.remarksLabel = new Label((Composite)clientDetails, 0);
        GridData remarksLabelData = new GridData(0x1000008, 0x1000000, true, false, 2, 1);
        remarksLabelData.horizontalIndent = 5;
        this.remarksLabel.setLayoutData((Object)remarksLabelData);
        Font font = new Font((Device)parent.getDisplay(), "Arial", 7, 0);
        Color redColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.remarksLabel.setFont(font);
        this.remarksLabel.setForeground(redColor);
        this.remarksLabel.setText("");
        this.remarksLabel.setText("**File Size should be Less than 2-MB**");
        Button browseButton = new Button((Composite)clientDetails, 8);
        browseButton.setText("Browse");
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ChequeDepositView.this.getSite().getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.jpeg"});
                String imagePath = fileDialog.open();
                if (imagePath != null) {
                    File imageFile = new File(imagePath);
                    long fileSize = imageFile.length();
                    if (fileSize <= 0x200000L) {
                        ChequeDepositView.this.imagePathText.setText(imagePath);
                        ChequeDepositView.this.remarksLabel.setText("");
                    } else {
                        MessageBox messageBox = new MessageBox(ChequeDepositView.this.getSite().getShell(), 33);
                        messageBox.setMessage("File size exceeds the maximum allowed limit (2 MB).");
                        ChequeDepositView.this.remarksLabel.setText("**File Size should be Less than 2-MB**");
                        messageBox.open();
                    }
                    try {
                        ChequeDepositView.this.ChequeImage = ChequeDepositView.this.uploadImage(ChequeDepositView.this.imagePathText.getText());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        Group btngrp = new Group((Composite)mainGroup, 131072);
        btngrp.setText("");
        btngrp.setLayout((Layout)new GridLayout(1, true));
        btngrp.setLayoutData((Object)new GridData(3, 3, false, false, 2, 1));
        this.btnSend = new Button((Composite)btngrp, 8);
        this.btnSend.setLayoutData((Object)btnGridData);
        this.btnSend.setText("Submit");
        this.btnSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    if (ChequeDepositView.this.selectedBankGlCode != null && !ChequeDepositView.this.selectedBankGlCode.equalsIgnoreCase("")) {
                        if (ChequeDepositView.this.ChequeImage != null && !ChequeDepositView.this.ChequeImage.equalsIgnoreCase("")) {
                            if (Integer.parseInt(ChequeDepositView.this.txtAmount.getText()) > 0) {
                                if (ChequeDepositView.this.uploadData()) {
                                    MessageDialog.openConfirm((Shell)ChequeDepositView.this.getViewSite().getShell(), (String)"Cheque Deposit Request", (String)"Your data has been uploaded Successfuly.");
                                    ChequeDepositView.this.clearFields();
                                } else {
                                    MessageDialog.openError((Shell)ChequeDepositView.this.getViewSite().getShell(), (String)"Cheque Deposit Request", (String)"Invalid Request: Contact Server Administrator.");
                                }
                            } else {
                                MessageDialog.openError((Shell)ChequeDepositView.this.getViewSite().getShell(), (String)"Cheque Deposit Request", (String)"Invalid Amount: Please Enter Valid Amount.");
                            }
                        } else {
                            MessageDialog.openError((Shell)ChequeDepositView.this.getViewSite().getShell(), (String)"Cheque Deposit Request", (String)"Invalid Image: Please Select Image (Jpeg,Jpg,Png).");
                        }
                    } else {
                        MessageDialog.openError((Shell)ChequeDepositView.this.getViewSite().getShell(), (String)"Cheque Deposit Request", (String)"Invalid Bank: Please Select Bank.");
                    }
                }
            }
        });
        this.buttonEnablement();
    }

    public long printFileSize(File fileName) {
        long bytes = 0L;
        try {
            bytes = fileName.length();
            System.out.println(String.format("%,d bytes", bytes));
            System.out.println(String.format("%,d kilobytes", bytes / 1024L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private void updateDropdown() {
        try {
            this.logger.info((Object)("bank key set" + bankData.keySet()));
            this.bankDropdown.removeAll();
            for (String bankName : bankData.keySet()) {
                this.logger.info((Object)("bank Name in dropdown" + bankName));
                this.bankDropdown.add(bankName);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("Invalid Bank Names: " + e));
        }
    }

    public void itemAdded(final Object o) {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        this.updateFields();
                    }
                }

                private void updateFields() {
                    ChequeDepositView.this.txtClientCode.setText(Resources.clientId);
                    ChequeDepositView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    ChequeDepositView.this.BankDataRetriever();
                    ChequeDepositView.this.updateDropdown();
                }
            });
        }
    }

    public void clearFields() {
        this.txtAmount.setText("");
        this.imagePathText.setText("");
        if (!Resources.isClientType()) {
            this.txtClientCode.setText("");
        }
    }

    public void itemRemoved(Object o) {
    }

    public void buttonEnablement() {
        this.btnSend.setEnabled(!this.txtClientCode.getText().trim().equals("") && !this.txtAmount.getText().trim().equals(""));
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ChequeDepositView.this.txtClientCode.setText(Resources.clientId);
                    ChequeDepositView.this.BankDataRetriever();
                    ChequeDepositView.this.updateDropdown();
                }
            });
        }
    }

    public void BankDataRetriever() {
        org.jfree.util.Log.warn((Object)"Bank Retriver");
        String url = "http://ms.bmatrade.com:8085/getBankList";
        try {
            String jsonResponse = ChequeDepositView.sendPostRequest(url);
            ChequeDepositView.processResponse(jsonResponse);
        }
        catch (Exception exception) {}
    }

    private static String sendPostRequest(String url) throws Exception {
        URL apiUrl = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.getOutputStream().write("{}".getBytes());
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            connection.disconnect();
            return response.toString();
        }
        connection.disconnect();
        throw new Exception("HTTP POST request failed with response code: " + responseCode);
    }

    private static void processResponse(String jsonResponse) {
        String[] bankObjects;
        int startIndex = jsonResponse.indexOf("[");
        int endIndex = jsonResponse.indexOf("]");
        String banksArrayStr = jsonResponse.substring(startIndex, endIndex + 1);
        String[] stringArray = bankObjects = banksArrayStr.split("\\},\\{");
        int n = bankObjects.length;
        int n2 = 0;
        while (n2 < n) {
            String bankObject = stringArray[n2];
            bankObject = bankObject.replaceAll("[\\[\\]\\{\\}]", "");
            String[] keyValuePairs = bankObject.split(",");
            String bankName = null;
            String glCode = null;
            String[] stringArray2 = keyValuePairs;
            int n3 = keyValuePairs.length;
            int n4 = 0;
            while (n4 < n3) {
                String keyValuePair = stringArray2[n4];
                String[] keyValue = keyValuePair.split(":");
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (key.equals("\"bankName\"")) {
                    bankName = value.replaceAll("\"", "");
                } else if (key.equals("\"glCode\"")) {
                    glCode = value.replaceAll("\"", "");
                }
                ++n4;
            }
            if (bankName != null && glCode != null) {
                bankData.put(bankName, glCode);
            }
            ++n2;
        }
    }

    private String uploadImage(String imagePath) throws IOException {
        File file = new File(imagePath);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] imageData = new byte[(int)file.length()];
        fileInputStream.read(imageData);
        String base64Image = DatatypeConverter.printBase64Binary((byte[])imageData);
        return base64Image;
    }

    public boolean uploadData() {
        String apiUrl = "http://ms.bmatrade.com:8085/savePayment";
        String userId = Resources.userId;
        String clientCode = this.txtClientCode.getText();
        String amount = this.txtAmount.getText();
        String fileName = String.valueOf(clientCode) + "_Cheque_Deposit_TT";
        try {
            String line;
            HashMap<String, String> payloadMap = new HashMap<String, String>();
            payloadMap.put("userId", userId);
            payloadMap.put("clientCode", clientCode);
            payloadMap.put("amount", amount);
            payloadMap.put("creationDate", "");
            payloadMap.put("fileName", fileName);
            payloadMap.put("status", "IN_PROCESS");
            payloadMap.put("post", "1");
            payloadMap.put("logId", "0");
            payloadMap.put("ipAddress", Resources.msIp);
            payloadMap.put("glCode", this.selectedBankGlCode);
            payloadMap.put("image64", this.ChequeImage);
            String payload = ChequeDepositView.mapToJson(payloadMap);
            System.out.println("Payload: " + payload);
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=utf-8");
            ChequeDepositView.setHeaders(connection, headers);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(payload.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
            int responseCode = connection.getResponseCode();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            System.out.println("Response Code: " + responseCode);
            System.out.println("Response: " + response.toString());
            return responseCode == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void setHeaders(HttpURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private static String mapToJson(Map<String, String> map) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            json.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\",");
        }
        if (!map.isEmpty()) {
            json.deleteCharAt(json.length() - 1);
        }
        json.append("}");
        return json.toString();
    }
}

