/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.CashWithdrawlRequest;
import pk.com.softech.messages.CashWithdrawlResponse;
import pk.com.softech.messages.ClientAccountRequest;
import pk.com.softech.messages.ClientAccountResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.WithdrawalSummaryRequest;
import pk.com.softech.messages.WithdrawalSummaryResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;
import pk.com.softech.util.Utility;

public class CashWithdrawalDialog
extends Dialog
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.cashWithdrawl";
    private Text txtClientCode;
    private Text txtCashAmnt;
    private Text txtAccNo;
    private Text txtAccTitle;
    private Text txtCashBalance;
    private Text txtWithdrawalLimit;
    private Text txtWithdrawalAmount;
    private Text txtRemainingAmount;
    private Text txtPendingWithdrawal;
    private Button btnBankTransfer;
    private Button btnChequeDelivery;
    private Button btnSubmit;
    private Button btnCancel;
    Composite parent;
    ScrolledComposite sc;
    Group withdrawalGroup;
    Group cashGroup;
    GridData withdrawalData;
    GridData cashData;
    GridData withdrawlData;
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    Log logger = LogFactory.getLog(this.getClass());
    final PriceVerifyListener priceVerifyListener = new PriceVerifyListener();

    public CashWithdrawalDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Cash Withdrawal");
        newShell.setLocation(480, 250);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Color clr = new Color((Device)parent.getDisplay(), 0, 0, 0);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group group = new Group(composite, 16);
        group.setText("Client Detail");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        group.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        new Label((Composite)group, 0x1000000).setText("Client Code");
        this.txtClientCode = new Text((Composite)group, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CashWithdrawalDialog.this.buttonEnablement();
            }
        });
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    CashWithdrawalDialog.this.sendClientDetailRequest();
                    if (Resources.systemClient == 1 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        CashWithdrawalDialog.this.sendWithdrawalSummaryRequest();
                    }
                }
            }
        });
        this.txtClientCode.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CashWithdrawalDialog.this.sendClientDetailRequest();
                if (Resources.systemClient == 1 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                    CashWithdrawalDialog.this.sendWithdrawalSummaryRequest();
                }
            }

            public void focusGained(FocusEvent e) {
                CashWithdrawalDialog.this.txtClientCode.selectAll();
            }
        });
        new Label((Composite)group, 0x1000000).setText("Account #");
        this.txtAccNo = new Text((Composite)group, 2048);
        this.txtAccNo.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        if (Resources.isClientType()) {
            this.txtAccNo.setText(Resources.clientAccCode);
        } else {
            this.txtAccNo.setText("");
        }
        this.txtAccNo.setForeground(clr);
        this.txtAccNo.setEnabled(false);
        this.txtAccNo.setEditable(false);
        new Label((Composite)group, 0x1000000).setText("Account Title");
        this.txtAccTitle = new Text((Composite)group, 2048);
        this.txtAccTitle.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        if (Resources.isClientType()) {
            this.txtAccTitle.setText(Resources.clientAccTitle);
        } else {
            this.txtAccTitle.setText("");
        }
        this.txtAccTitle.setForeground(clr);
        this.txtAccTitle.setEnabled(false);
        this.txtAccTitle.setEditable(false);
        group = new Group(composite, 16);
        group.setText("Select Operation");
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        group.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.btnBankTransfer = new Button((Composite)group, 16);
        this.btnBankTransfer.setText("Bank Transfer");
        this.btnBankTransfer.setSelection(true);
        this.btnChequeDelivery = new Button((Composite)group, 16);
        this.btnChequeDelivery.setText("Cheque Delivery");
        this.withdrawalGroup = new Group(composite, 16);
        this.withdrawalGroup.setLayout((Layout)new GridLayout(2, false));
        this.withdrawalData = new GridData(1, 0x1000000, false, false, 2, 1);
        this.withdrawalGroup.setLayoutData((Object)this.withdrawalData);
        new Label((Composite)this.withdrawalGroup, 0).setText("Cash Balance              = PKR");
        this.txtCashBalance = new Text((Composite)this.withdrawalGroup, 2048);
        this.txtCashBalance.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtCashBalance.addVerifyListener((VerifyListener)this.priceVerifyListener);
        this.txtCashBalance.setForeground(clr);
        this.txtCashBalance.setEnabled(false);
        this.txtCashBalance.setEditable(false);
        new Label((Composite)this.withdrawalGroup, 0).setText("Withdrawal Limit       = PKR");
        this.txtWithdrawalLimit = new Text((Composite)this.withdrawalGroup, 2048);
        this.txtWithdrawalLimit.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtWithdrawalLimit.setForeground(clr);
        this.txtWithdrawalLimit.setEnabled(false);
        this.txtWithdrawalLimit.setEditable(false);
        new Label((Composite)this.withdrawalGroup, 0).setText("Pending Withdrawal  = PKR");
        this.txtPendingWithdrawal = new Text((Composite)this.withdrawalGroup, 2048);
        this.txtPendingWithdrawal.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtPendingWithdrawal.addVerifyListener((VerifyListener)this.priceVerifyListener);
        this.txtPendingWithdrawal.setForeground(clr);
        this.txtPendingWithdrawal.setEnabled(false);
        this.txtPendingWithdrawal.setEditable(false);
        new Label((Composite)this.withdrawalGroup, 0).setText("Withdrawal Amount  = PKR");
        this.txtWithdrawalAmount = new Text((Composite)this.withdrawalGroup, 2048);
        this.txtWithdrawalAmount.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtWithdrawalAmount.addVerifyListener((VerifyListener)this.priceVerifyListener);
        this.txtWithdrawalAmount.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    CashWithdrawalDialog.this.sendCashWithdrawRequest();
                }
            }
        });
        this.txtWithdrawalAmount.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    if (!CashWithdrawalDialog.this.txtWithdrawalAmount.getText().equals("")) {
                        double remaining = Utility.parseDouble((String)CashWithdrawalDialog.this.txtWithdrawalLimit.getText(), (double)0.0) - Utility.parseDouble((String)CashWithdrawalDialog.this.txtWithdrawalAmount.getText(), (double)0.0);
                        CashWithdrawalDialog.this.txtRemainingAmount.setText("");
                        CashWithdrawalDialog.this.txtRemainingAmount.setText(CashWithdrawalDialog.this.pf.format(remaining));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CashWithdrawalDialog.this.logger.info((Object)ex);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.txtWithdrawalAmount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CashWithdrawalDialog.this.buttonEnablement();
            }
        });
        new Label((Composite)this.withdrawalGroup, 0).setText("Remaining Amount   = PKR");
        this.txtRemainingAmount = new Text((Composite)this.withdrawalGroup, 2048);
        this.txtRemainingAmount.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtRemainingAmount.addVerifyListener((VerifyListener)this.priceVerifyListener);
        this.txtRemainingAmount.setForeground(clr);
        this.txtRemainingAmount.setEnabled(true);
        this.txtRemainingAmount.setEditable(false);
        this.cashGroup = new Group(composite, 16);
        this.cashGroup.setLayout((Layout)new GridLayout(2, false));
        this.cashData = new GridData(1, 0x1000000, false, false, 2, 1);
        this.cashGroup.setLayoutData((Object)this.cashData);
        new Label((Composite)this.cashGroup, 0).setText("Cash Amount");
        this.txtCashAmnt = new Text((Composite)this.cashGroup, 2048);
        this.txtCashAmnt.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.txtCashAmnt.addVerifyListener((VerifyListener)this.priceVerifyListener);
        this.txtCashAmnt.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    CashWithdrawalDialog.this.sendCashWithdrawRequest();
                }
            }
        });
        this.txtCashAmnt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CashWithdrawalDialog.this.buttonEnablement();
            }
        });
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)new GridLayout(2, false));
        btnComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.btnSubmit = new Button(btnComposite, 8);
        this.btnSubmit.setText("Submit");
        this.btnSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CashWithdrawalDialog.this.sendCashWithdrawRequest();
            }
        });
        this.btnCancel = new Button(btnComposite, 8);
        this.btnCancel.setText("Clear");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Resources.isClientType()) {
                    CashWithdrawalDialog.this.txtClientCode.setText("");
                    CashWithdrawalDialog.this.txtAccNo.setText("");
                    CashWithdrawalDialog.this.txtAccTitle.setText("");
                    if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        CashWithdrawalDialog.this.txtCashBalance.setText("");
                        CashWithdrawalDialog.this.txtWithdrawalLimit.setText("");
                        CashWithdrawalDialog.this.txtPendingWithdrawal.setText("");
                        CashWithdrawalDialog.this.txtWithdrawalAmount.setText("");
                        CashWithdrawalDialog.this.txtRemainingAmount.setText("");
                    } else {
                        CashWithdrawalDialog.this.txtCashAmnt.setText("");
                    }
                } else if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                    CashWithdrawalDialog.this.txtWithdrawalAmount.setText("");
                    CashWithdrawalDialog.this.txtRemainingAmount.setText("");
                } else {
                    CashWithdrawalDialog.this.txtCashAmnt.setText("");
                }
                CashWithdrawalDialog.this.buttonEnablement();
            }
        });
        if (Resources.loginStatus) {
            if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                this.cashData.exclude = !this.cashData.exclude;
                this.cashGroup.setVisible(!this.cashData.exclude);
                this.cashGroup.getParent().pack();
                if (Resources.isClientType() || Resources.isClientTypeAbbasiSupport()) {
                    this.sendWithdrawalSummaryRequest();
                }
            } else {
                this.withdrawalData.exclude = !this.withdrawalData.exclude;
                this.withdrawalGroup.setVisible(!this.withdrawalData.exclude);
                this.withdrawalGroup.getParent().pack();
            }
        }
        this.buttonEnablement();
        return composite;
    }

    private void sendClientDetailRequest() {
        if (!this.txtClientCode.getText().equals("")) {
            if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)new ClientAccountRequest(this.txtClientCode.getText()));
                if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                    this.txtWithdrawalAmount.setFocus();
                } else {
                    this.txtCashAmnt.forceFocus();
                }
            } else {
                this.txtClientCode.setText("");
            }
        } else {
            this.txtAccNo.setText("");
            this.txtAccTitle.setText("");
        }
    }

    private void recieveClientDetailResponse(final ClientAccountResponse resp) {
        if (resp != null && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (resp.getAccount() != null && resp.getTitle() != null) {
                        CashWithdrawalDialog.this.txtAccNo.setText(resp.getAccount());
                        CashWithdrawalDialog.this.txtAccTitle.setText(resp.getTitle());
                    }
                }
            });
        }
    }

    public void sendWithdrawalSummaryRequest() {
        if (!this.txtClientCode.getText().equals("")) {
            if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)new WithdrawalSummaryRequest(this.txtClientCode.getText(), Boolean.valueOf(Resources.userType == 3)));
                this.txtWithdrawalAmount.forceFocus();
            } else {
                this.txtClientCode.setText("");
            }
        } else {
            this.txtCashBalance.setText("");
            this.txtWithdrawalAmount.setText("");
            this.txtWithdrawalLimit.setText("");
            this.txtPendingWithdrawal.setText("");
            this.txtRemainingAmount.setText("");
        }
    }

    public void recieveWithdrawalSummaryResponse(final WithdrawalSummaryResponse resp) {
        if (resp != null && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CashWithdrawalDialog.this.txtWithdrawalLimit.setText("");
                        CashWithdrawalDialog.this.txtPendingWithdrawal.setText("");
                        CashWithdrawalDialog.this.txtCashBalance.setText("");
                        CashWithdrawalDialog.this.txtWithdrawalAmount.setText("");
                        CashWithdrawalDialog.this.txtRemainingAmount.setText("");
                        CashWithdrawalDialog.this.txtPendingWithdrawal.setText(CashWithdrawalDialog.this.pf.format(resp.getPendingWithdrawal()));
                        CashWithdrawalDialog.this.txtCashBalance.setText(CashWithdrawalDialog.this.pf.format(resp.getCashBalance()));
                        CashWithdrawalDialog.this.txtWithdrawalLimit.setText(CashWithdrawalDialog.this.pf.format(resp.getWithdrawalLimit()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        CashWithdrawalDialog.this.logger.info((Object)e);
                    }
                }
            });
        }
    }

    private void sendCashWithdrawRequest() {
        Resources.respCashTransffer = null;
        try {
            String operation = "";
            int cash = 0;
            if (!this.txtClientCode.getText().trim().equals("")) {
                cash = Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24 ? Utility.parseInt((String)this.txtWithdrawalAmount.getText(), (int)0) : Utility.parseInt((String)this.txtCashAmnt.getText(), (int)0);
                if (cash == 0) {
                    MessageDialog.openWarning(null, (String)"Cash Withdrawal", (String)"Invalid Request: Invalid cash amount.");
                    if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        this.txtWithdrawalAmount.setFocus();
                    } else {
                        this.txtCashAmnt.forceFocus();
                    }
                } else {
                    if (this.btnChequeDelivery.getSelection()) {
                        operation = "CHEQUE DELIVERY";
                    } else if (this.btnBankTransfer.getSelection()) {
                        if (this.txtAccNo.getText() == null || this.txtAccNo.getText().trim().equals("") || this.txtAccTitle.getText() == null || this.txtAccTitle.getText().trim().equals("")) {
                            MessageDialog.openWarning(null, (String)"Cash Withdrawal", (String)"Dear Client your Bank details are not configured pls. contact our Support to avail the bank transfer facility");
                            return;
                        }
                        operation = "BANK TRANSFER";
                    } else {
                        MessageDialog.openWarning(null, (String)"Cash Withdrawal", (String)"Invalid option selected for cash widthdrawl.");
                        return;
                    }
                    if (MessageDialog.openQuestion(null, (String)"Cash Withdrawal", (String)"Do you want to continue with the online cash withdrawal transaction?") && Resources.isServerConnected((String)this.txtClientCode.getText().trim(), (boolean)true, (boolean)false)) {
                        CashWithdrawlRequest r = new CashWithdrawlRequest(this.txtClientCode.getText().trim(), this.txtAccNo.getText(), this.txtAccTitle.getText(), cash, operation);
                        if (Resources.getServerLink((String)this.txtClientCode.getText().trim(), (boolean)true, (boolean)false).writeData((Object)r)) {
                            this.logger.info((Object)("cash withdraw request sent for " + this.txtClientCode.getText().trim() + " at link = " + Resources.getServerLink((String)this.txtClientCode.getText().trim(), (boolean)true, (boolean)false)));
                            if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                                this.txtWithdrawalAmount.setText("");
                                this.txtRemainingAmount.setText("");
                            } else {
                                this.txtCashAmnt.setText("");
                            }
                            this.btnSubmit.setEnabled(false);
                            BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    while (Resources.respCashWithdrawal == null) {
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            });
                            this.receiveResponse(Resources.respCashWithdrawal);
                        }
                    }
                }
            } else {
                MessageDialog.openWarning(null, (String)"Cash Withdrawal", (String)"Invalid Request: Client Code has not been entered.");
                if (Resources.isClientType() || Resources.isClientTypeAbbasiSupport()) {
                    if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        this.txtWithdrawalAmount.forceFocus();
                    } else {
                        this.txtCashAmnt.forceFocus();
                    }
                } else {
                    this.txtClientCode.forceFocus();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void receiveResponse(final CashWithdrawlResponse response) {
        this.logger.info((Object)"cash transffer response recieved ");
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int action = response.getAction();
                        if (action == 1) {
                            MessageDialog.openInformation(null, (String)"Cash Withdrawal", (String)response.getRemarks());
                        } else if (action == 2) {
                            MessageDialog.openError(null, (String)"Cash Withdrawal", (String)response.getRemarks());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void buttonEnablement() {
        this.btnSubmit.setEnabled(!this.txtClientCode.getText().trim().equals("") && this.priceVerifyListener.isValid());
    }

    public void itemAdded(final Object o) {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        CashWithdrawalDialog.this.txtClientCode.setText(Resources.clientId);
                        CashWithdrawalDialog.this.txtClientCode.setEnabled(!Resources.isClientType());
                        if (Resources.isClientType() || Resources.isClientTypeAbbasiSupport()) {
                            CashWithdrawalDialog.this.txtAccNo.setText(Resources.clientAccCode);
                            CashWithdrawalDialog.this.txtAccTitle.setText(Resources.clientAccTitle);
                            if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                                CashWithdrawalDialog.this.sendWithdrawalSummaryRequest();
                            }
                        } else {
                            CashWithdrawalDialog.this.txtAccNo.setText("");
                            CashWithdrawalDialog.this.txtAccTitle.setText("");
                        }
                    } else if (o instanceof ClientAccountResponse) {
                        CashWithdrawalDialog.this.recieveClientDetailResponse((ClientAccountResponse)o);
                    } else if (o instanceof WithdrawalSummaryResponse) {
                        CashWithdrawalDialog.this.recieveWithdrawalSummaryResponse((WithdrawalSummaryResponse)o);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void setFocus() {
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        return super.close();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CashWithdrawalDialog.this.txtClientCode.setText(Resources.clientId);
                    CashWithdrawalDialog.this.sendClientDetailRequest();
                    if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        CashWithdrawalDialog.this.sendWithdrawalSummaryRequest();
                    }
                }
            });
        }
    }

    protected void okPressed() {
    }
}

