/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.actions.DeleteAction;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.AlertPropertiesDialog;
import pk.com.softech.tradingterminal.trading.wizards.NewAlertWizard;

public class AlertView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.alertView";
    private Table table;
    private Action newAlertAction;
    private Action propertiesAction;
    private Action deleteAction;
    private Action resetAction;
    private int alertID = 0;
    private Composite parent;

    public AlertView() {
        CorePlugin.getRepository().allAlerts().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.newAlertAction = new Action("New Alert"){

            public void run() {
                AlertView.this.openNewAlertWizard();
            }
        };
        this.propertiesAction = new Action("Properties"){

            public void run() {
                TableItem[] selection = AlertView.this.table.getSelection();
                if (selection.length != 0) {
                    AlertPropertiesDialog dlg = new AlertPropertiesDialog((Alert)selection[0].getData(), AlertView.this.getViewSite().getShell());
                    dlg.open();
                }
            }
        };
        this.deleteAction = new DeleteAction(){

            public void run() {
                if (AlertView.this.table.getSelection()[0] != null) {
                    CorePlugin.getRepository().delete((PersistentObject)((Alert)AlertView.this.table.getSelection()[0].getData()));
                }
                AlertView.this.table.getItem(AlertView.this.table.getSelectionIndex()).dispose();
            }
        };
        this.resetAction = new Action("Reset"){

            public void run() {
                if (AlertView.this.table.getSelectionIndex() != -1) {
                    int index = AlertView.this.table.getSelectionIndex();
                    Alert resetAlert = (Alert)AlertView.this.table.getItem(index).getData();
                    ((AlertPlugin)resetAlert.getData()).setLastSeen(null);
                    resetAlert.setLastSeen(null);
                    resetAlert.setChanged();
                    resetAlert.notifyObservers();
                }
            }
        };
        this.resetAction.setToolTipText("Reset last seen");
        this.addActions();
        this.table = new Table(parent, 67588);
        TableColumn tc1 = new TableColumn(this.table, 0x1000000);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        TableColumn tc4 = new TableColumn(this.table, 0x1000000);
        tc1.setText("Symbol");
        tc2.setText("Alert");
        tc3.setText("Description");
        tc4.setText("Last Seen");
        this.table.setHeaderVisible(true);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.newAlertAction);
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IAction)this.resetAction);
        menuManager.add((IAction)this.propertiesAction);
        Menu menu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (AlertView.this.table.getItem(new Point(e.x, e.y)) == null) {
                    AlertView.this.table.deselectAll();
                }
                AlertView.this.deleteAction.setEnabled(AlertView.this.table.getSelectionIndex() != -1);
                AlertView.this.propertiesAction.setEnabled(AlertView.this.table.getSelectionIndex() != -1);
                AlertView.this.resetAction.setEnabled(AlertView.this.table.getSelectionIndex() != -1 && ((Alert)AlertView.this.table.getItem(AlertView.this.table.getSelectionIndex()).getData()).getLastSeen() != null);
            }
        });
        for (Alert alert : CorePlugin.getRepository().allAlerts()) {
            alert.setId("" + ++this.alertID);
            this.fillTableItems(alert);
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    protected void openNewAlertWizard() {
        NewAlertWizard wizard = new NewAlertWizard();
        wizard.open();
    }

    private void addActions() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.newAlertAction);
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IAction)this.resetAction);
        menuManager.add((IAction)this.propertiesAction);
    }

    public void setFocus() {
    }

    public void itemAdded(Object o) {
        this.fillTableItems((Alert)o);
    }

    private void fillTableItems(Alert alert) {
        if (alert == null) {
            CorePlugin.logException((String)"Null alert in AlertsView");
            return;
        }
        alert.addObserver((Observer)this);
        alert.getSecurity().getQuoteMonitor().addObserver((Observer)this);
        AlertPlugin plugin = (AlertPlugin)alert.getData();
        if (plugin == null) {
            plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
            plugin.init(alert.getSecurity(), alert.getParameters());
            plugin.setLastSeen(alert.getLastSeen());
            alert.setData((Object)plugin);
        }
        if (plugin != null && !plugin.isSeenToday() && plugin.apply()) {
            plugin.setLastSeen(Calendar.getInstance().getTime());
            alert.setLastSeen(plugin.getLastSeen());
            if (alert.isHilight()) {
                System.out.println("*************alert******************");
            }
        }
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, alert.getSecurity().getId());
        tableItem.setText(1, TradingPlugin.getAlertPluginName(alert.getPluginId()));
        tableItem.setText(2, plugin.getDescription());
        if (alert.getLastSeen() != null) {
            tableItem.setText(3, CorePlugin.getDateTimeFormatLong().format(alert.getLastSeen()));
        }
        tableItem.setData((Object)alert);
    }

    public void itemRemoved(Object o) {
        Alert alert = (Alert)o;
        alert.deleteObserver((Observer)this);
        alert.getSecurity().getQuoteMonitor().deleteObserver((Observer)this);
        System.out.println("item removed from alerts" + alert.getSecurity().getId());
    }

    public void dispose() {
        CorePlugin.getRepository().allAlerts().removeCollectionObserver((ICollectionObserver)this);
        for (Alert alert : CorePlugin.getRepository().allAlerts()) {
            alert.getSecurity().getQuoteMonitor().deleteObserver((Observer)this);
            alert.deleteObserver((Observer)this);
        }
        super.dispose();
    }

    @Override
    public void update(final Observable o, Object arg1) {
        if (o instanceof Alert) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Alert alert = (Alert)o;
                    AlertPlugin plugin = (AlertPlugin)alert.getData();
                    int i = 0;
                    while (i < AlertView.this.table.getItemCount()) {
                        Alert row = (Alert)AlertView.this.table.getItem(i).getData();
                        if (row.getId() == alert.getId()) {
                            AlertView.this.table.getItem(i).setText(1, TradingPlugin.getAlertPluginName(alert.getPluginId()));
                            AlertView.this.table.getItem(i).setText(2, plugin.getDescription());
                            if (alert.getLastSeen() != null) {
                                AlertView.this.table.getItem(i).setText(3, CorePlugin.getDateTimeFormatLong().format(alert.getLastSeen()));
                            } else {
                                AlertView.this.table.getItem(i).setText(3, "");
                            }
                            AlertView.this.table.getItem(i).setData((Object)alert);
                        }
                        ++i;
                    }
                    if (plugin != null && !plugin.isSeenToday() && plugin.apply()) {
                        plugin.setLastSeen(Calendar.getInstance().getTime());
                        alert.setLastSeen(plugin.getLastSeen());
                        if (alert.isHilight()) {
                            System.out.println("###############################");
                        }
                    }
                }
            });
        } else if (arg1 instanceof Security) {
            Security sec = (Security)arg1;
            int i = 0;
            while (i < CorePlugin.getRepository().allAlerts().size()) {
                AlertPlugin plugin;
                Alert alert = (Alert)CorePlugin.getRepository().allAlerts().get(i);
                if (alert.getSecurity().getId().equals(sec.getId()) && (plugin = (AlertPlugin)alert.getData()) != null && !plugin.isSeenToday() && plugin.apply()) {
                    plugin.setLastSeen(Calendar.getInstance().getTime());
                    alert.setLastSeen(plugin.getLastSeen());
                    alert.setChanged();
                    alert.notifyObservers();
                }
                ++i;
            }
        }
    }
}

