/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class AlertPropertiesDialog
extends Dialog {
    private Table table;
    private Alert alert;
    private Composite parent;
    private Composite group;
    private Button reset;
    private Button popup;
    private Button hilight;

    protected AlertPropertiesDialog(Alert alert, Shell parentShell) {
        super(parentShell);
        this.alert = alert;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(String.valueOf(this.alert.getSecurity().getDescription()) + " Properties");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite container = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(content, 65540);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 250;
        gridData.heightHint = this.table.getItemHeight() * 5;
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AlertPropertiesDialog.this.table.getSelectionIndex() != -1) {
                    CTabFolder folder = (CTabFolder)AlertPropertiesDialog.this.group.getChildren()[AlertPropertiesDialog.this.table.getSelectionIndex()];
                    ((StackLayout)((AlertPropertiesDialog)AlertPropertiesDialog.this).group.getLayout()).topControl = folder;
                    AlertPropertiesDialog.this.reset.setEnabled(AlertPropertiesDialog.this.table.getSelectionIndex() != -1 && AlertPropertiesDialog.this.alert.getLastSeen() != null);
                    AlertPropertiesDialog.this.popup.setEnabled(true);
                    AlertPropertiesDialog.this.popup.setSelection(((Boolean)folder.getData("popup")).booleanValue());
                    AlertPropertiesDialog.this.hilight.setEnabled(true);
                    AlertPropertiesDialog.this.hilight.setSelection(((Boolean)folder.getData("hilight")).booleanValue());
                } else {
                    AlertPropertiesDialog.this.reset.setEnabled(false);
                    AlertPropertiesDialog.this.popup.setEnabled(false);
                    AlertPropertiesDialog.this.popup.setSelection(false);
                    AlertPropertiesDialog.this.hilight.setEnabled(false);
                    AlertPropertiesDialog.this.hilight.setSelection(false);
                }
                AlertPropertiesDialog.this.group.layout();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (AlertPropertiesDialog.this.table.getItem(new Point(e.x, e.y)) == null) {
                    AlertPropertiesDialog.this.table.deselectAll();
                    ((StackLayout)((AlertPropertiesDialog)AlertPropertiesDialog.this).group.getLayout()).topControl = null;
                    AlertPropertiesDialog.this.group.layout();
                    AlertPropertiesDialog.this.reset.setEnabled(false);
                    AlertPropertiesDialog.this.popup.setEnabled(false);
                    AlertPropertiesDialog.this.popup.setSelection(false);
                    AlertPropertiesDialog.this.hilight.setEnabled(false);
                    AlertPropertiesDialog.this.hilight.setSelection(false);
                }
            }
        });
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Description");
        column = new TableColumn(this.table, 0);
        column.setText("Last");
        Composite buttons = new Composite(content, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(1, 4, false, false));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.reset = new Button(buttons, 8);
        this.reset.setImage(images.getImageDescriptor("IMG_TOOL_UNDO").createImage());
        this.reset.setToolTipText("Reset last seen");
        this.reset.setEnabled(false);
        this.reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AlertPropertiesDialog.this.table.getSelectionIndex() != -1) {
                    int index = AlertPropertiesDialog.this.table.getSelectionIndex();
                    ((CTabFolder)AlertPropertiesDialog.this.table.getItem(index).getData("folder")).setData("last", null);
                    AlertPropertiesDialog.this.table.getItem(index).setText(1, "");
                }
                AlertPropertiesDialog.this.reset.setEnabled(false);
            }
        });
        this.group = new Composite(content, 0);
        this.group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.group.setLayout((Layout)new StackLayout());
        this.itemAdded(this.alert);
        this.popup = new Button(content, 32);
        this.popup.setText("Pop-up a message");
        this.popup.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.popup.setEnabled(false);
        this.popup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder folder = (CTabFolder)((StackLayout)((AlertPropertiesDialog)AlertPropertiesDialog.this).group.getLayout()).topControl;
                folder.setData("popup", (Object)new Boolean(AlertPropertiesDialog.this.popup.getSelection()));
            }
        });
        this.hilight = new Button(content, 32);
        this.hilight.setText("Pop-up notification");
        this.hilight.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.hilight.setEnabled(false);
        this.hilight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder folder = (CTabFolder)((StackLayout)((AlertPropertiesDialog)AlertPropertiesDialog.this).group.getLayout()).topControl;
                folder.setData("hilight", (Object)new Boolean(AlertPropertiesDialog.this.hilight.getSelection()));
            }
        });
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        return content;
    }

    protected void okPressed() {
        Control[] childs = this.group.getChildren();
        int i = 0;
        while (i < childs.length) {
            HashMap parameters = new HashMap();
            CTabItem[] items = ((CTabFolder)childs[i]).getItems();
            int p = 0;
            while (p < items.length) {
                AlertPluginPreferencePage page = (AlertPluginPreferencePage)items[p].getData();
                page.performOk();
                parameters.putAll(page.getParameters());
                ++p;
            }
            this.alert = (Alert)childs[i].getData();
            this.alert.setParameters(parameters);
            this.alert.setLastSeen((Date)((CTabFolder)this.table.getItem(i).getData("folder")).getData("last"));
            this.alert.setPopup(((Boolean)childs[i].getData("popup")).booleanValue());
            this.alert.setHilight(((Boolean)childs[i].getData("hilight")).booleanValue());
            ((AlertPlugin)this.alert.getData()).init(parameters);
            ((AlertPlugin)this.alert.getData()).setLastSeen(this.alert.getLastSeen());
            this.alert.setChanged();
            this.alert.notifyObservers();
            ++i;
        }
        super.okPressed();
    }

    private void itemAdded(Alert alert) {
        AlertPlugin plugin = (AlertPlugin)alert.getData();
        if (plugin == null) {
            plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
            plugin.init(alert.getSecurity(), alert.getParameters());
            alert.setData((Object)plugin);
        }
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, String.valueOf(plugin.getDescription()) + " (" + TradingPlugin.getAlertPluginName(alert.getPluginId()) + ")");
        if (alert.getLastSeen() != null) {
            tableItem.setText(1, CorePlugin.getDateTimeFormatLong().format(alert.getLastSeen()));
        }
        tableItem.setData((Object)alert);
        CTabFolder folder = new CTabFolder(this.group, 0x800880);
        folder.setMaximizeVisible(false);
        folder.setMinimizeVisible(false);
        folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        folder.setData((Object)alert);
        folder.setData("last", (Object)plugin.getLastSeen());
        folder.setData("popup", (Object)new Boolean(alert.isPopup()));
        folder.setData("hilight", (Object)new Boolean(alert.isHilight()));
        tableItem.setData("folder", (Object)folder);
        IConfigurationElement[] pages = TradingPlugin.getAlertPluginPreferencePages(alert.getPluginId());
        int i = 0;
        while (i < pages.length) {
            CTabItem tabItem = new CTabItem(folder, 0);
            Composite itemContent = new Composite((Composite)folder, 0);
            itemContent.setLayout((Layout)new GridLayout());
            tabItem.setControl((Control)itemContent);
            tabItem.setText(pages[i].getAttribute("name"));
            if (pages[i].getAttribute("description") != null) {
                tabItem.setToolTipText(pages[i].getAttribute("description"));
            }
            try {
                AlertPluginPreferencePage page = (AlertPluginPreferencePage)pages[i].createExecutableExtension("class");
                page.init(alert.getSecurity(), alert.getParameters());
                Control control = page.createContents(itemContent);
                if (control instanceof Composite) {
                    ((Composite)control).setLayoutData((Object)new GridData(4, 4, true, true));
                }
                tabItem.setData((Object)page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            folder.setSelection(0);
            ++i;
        }
    }
}

