/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.export;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class TradingDataSelectionPage
extends WizardPage {
    public static final String EXPORT_FILE_NAME = "/TradingData";
    public static final int HISTORICAL_PRICES = 0;
    public static final int INTRADAY_PRICES = 1;
    public static final int LAST_PRICES = 2;
    Button all;
    Button selected;
    List list;
    Button historical;
    Button intraday;
    Button prices;
    Text file;

    public TradingDataSelectionPage() {
        super("Export Historical Data");
        this.setTitle(Messages.TradingData_Export_Title);
        this.setDescription(Messages.TradingData_Export_Description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        this.all = new Button(content, 16);
        this.all.setText(Messages.ExportSelectionPage_All);
        this.all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradingDataSelectionPage.this.list.setEnabled(false);
                TradingDataSelectionPage.this.setPageComplete((TradingDataSelectionPage.this.list.getSelectionIndex() != -1 || TradingDataSelectionPage.this.all.getSelection()) && TradingDataSelectionPage.this.file.getText().length() != 0);
            }
        });
        this.selected = new Button(content, 16);
        this.selected.setText(Messages.ExportSelectionPage_Selected);
        this.selected.setSelection(true);
        this.selected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradingDataSelectionPage.this.list.setEnabled(true);
                TradingDataSelectionPage.this.setPageComplete((TradingDataSelectionPage.this.list.getSelectionIndex() != -1 || TradingDataSelectionPage.this.all.getSelection()) && TradingDataSelectionPage.this.file.getText().length() != 0);
            }
        });
        this.list = new List(content, 2562);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.list.getItemHeight() * 10;
        this.list.setLayoutData((Object)gridData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradingDataSelectionPage.this.setPageComplete((TradingDataSelectionPage.this.list.getSelectionIndex() != -1 || TradingDataSelectionPage.this.all.getSelection()) && TradingDataSelectionPage.this.file.getText().length() != 0);
            }
        });
        ObservableList securities = CorePlugin.getRepository().allSecurities();
        Collections.sort(securities, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Security)arg0).getSymbol().trim().compareTo(((Security)arg1).getSymbol().trim());
            }
        });
        for (Security security : securities) {
            this.list.add(String.valueOf(security.getSymbol()) + "(" + security.getMarket() + ")");
            this.list.setData(String.valueOf(this.list.getItemCount() - 1), (Object)security);
        }
        Label label = new Label(content, 0);
        label.setText(Messages.ExportSelectionPage_SelectLabel);
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 2, true, false));
        this.historical = new Button(group, 16);
        this.historical.setText(Messages.ExportSelectionPage_Historical);
        this.historical.setSelection(true);
        this.intraday = new Button(group, 16);
        this.intraday.setText(Messages.ExportSelectionPage_intraday);
        this.prices = new Button(group, 16);
        this.prices.setText(Messages.ExportSelectionPage_Last);
        label = new Label(content, 0);
        label.setText(Messages.ExportSelectionPage_DestinationLabel);
        group = new Composite(content, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 2, true, false));
        label = new Label(group, 0);
        label.setText(Messages.ExportSelectionPage_FileLabel);
        this.file = new Text(group, 2048);
        this.file.setLayoutData((Object)new GridData(4, 2, true, false));
        this.file.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TradingDataSelectionPage.this.setPageComplete((TradingDataSelectionPage.this.list.getSelectionIndex() != -1 || TradingDataSelectionPage.this.all.getSelection()) && TradingDataSelectionPage.this.acceptFileName());
            }
        });
        Button button = new Button(group, 8);
        button.setText(Messages.ExportSelectionPage_BrowseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(TradingDataSelectionPage.this.getShell(), 8192);
                fd.setText("Save");
                String selected = fd.open();
                if (selected != null) {
                    TradingDataSelectionPage.this.file.setText(selected);
                    TradingDataSelectionPage.this.setPageComplete((TradingDataSelectionPage.this.list.getSelectionIndex() != -1 || TradingDataSelectionPage.this.all.getSelection()) && TradingDataSelectionPage.this.acceptFileName());
                }
            }
        });
    }

    public Security[] getSelectedSecurity() {
        if (this.selected.getSelection()) {
            int[] indices = this.list.getSelectionIndices();
            Security[] selection = new Security[indices.length];
            int i = 0;
            while (i < selection.length) {
                selection[i] = (Security)this.list.getData(String.valueOf(indices[i]));
                ++i;
            }
            return selection;
        }
        return (Security[])CorePlugin.getRepository().allSecurities().toArray((Object[])new Security[0]);
    }

    public String getFile() {
        return this.file.getText();
    }

    public boolean acceptFileName() {
        String filePath = this.file.getText();
        if (filePath != null && filePath.length() > 0) {
            int lastIndex = filePath.lastIndexOf("/");
            String fileName = filePath.substring(lastIndex + 1);
            File f = new File(filePath);
            if (fileName.indexOf(".") != 0 && fileName.length() > 0 && !f.isDirectory()) {
                return true;
            }
        }
        return false;
    }

    public int getDataToExport() {
        if (this.historical.getSelection()) {
            return 0;
        }
        if (this.intraday.getSelection()) {
            return 1;
        }
        if (this.prices.getSelection()) {
            return 2;
        }
        return -1;
    }
}

