/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.export;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;
import pk.com.softech.tradingterminal.trading.ui.export.TradingDataSelectionPage;

public class TradingDataExport
extends Wizard
implements IExportWizard {
    TradingDataSelectionPage securitySelectionPage = new TradingDataSelectionPage();
    String separator = ",";
    String eol = "\r\n";
    String fieldsFormat = "Exchange|Market|Symbol|Date|Open|High|Low|Close|Volume";

    public TradingDataExport() {
        this.setWindowTitle(Messages.TradingData_Export_Title);
        this.addPage((IWizardPage)this.securitySelectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final Security[] security = this.securitySelectionPage.getSelectedSecurity();
        final int export = this.securitySelectionPage.getDataToExport();
        final String file = this.securitySelectionPage.getFile();
        Job job = new Job(Messages.TradingData_Export_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
                SimpleDateFormat dateTimeFormat = CorePlugin.getDateTimeFormat();
                NumberFormat priceFormat = NumberFormat.getInstance(Locale.US);
                priceFormat.setMinimumIntegerDigits(1);
                priceFormat.setMinimumFractionDigits(4);
                priceFormat.setMaximumFractionDigits(4);
                priceFormat.setGroupingUsed(false);
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                numberFormat.setMinimumIntegerDigits(1);
                numberFormat.setMinimumFractionDigits(0);
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setGroupingUsed(false);
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    if (export == 0) {
                        monitor.beginTask(Messages.TradingData_Export_HistoricalTask, security.length);
                        writer.write(String.valueOf(TradingDataExport.this.fieldsFormat) + TradingDataExport.this.eol);
                        int i = 0;
                        while (i < security.length) {
                            monitor.subTask(security[i].getDescription());
                            for (Bar bar : security[i].getHistory()) {
                                writer.write(String.valueOf(security[i].getExchange()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getMarket()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getSymbol()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(dateFormat.format(bar.getDate())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getOpen())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getHigh())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getLow())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getClose())) + TradingDataExport.this.separator);
                                writer.write(numberFormat.format(bar.getVolume()));
                                writer.write(TradingDataExport.this.eol);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    } else if (export == 1) {
                        monitor.beginTask(Messages.TradingData_Export_IntradayTask, security.length);
                        writer.write(String.valueOf(TradingDataExport.this.fieldsFormat) + TradingDataExport.this.eol);
                        int i = 0;
                        while (i < security.length) {
                            monitor.setTaskName(security[i].getDescription());
                            for (Bar bar : security[i].getIntradayHistory()) {
                                writer.write(String.valueOf(security[i].getExchange()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getMarket()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getSymbol()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(dateTimeFormat.format(bar.getDate())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getOpen())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getHigh())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getLow())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(bar.getClose())) + TradingDataExport.this.separator);
                                writer.write(numberFormat.format(bar.getVolume()));
                                writer.write(TradingDataExport.this.eol);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    } else if (export == 2) {
                        monitor.beginTask(Messages.TradingData_Export_LastTask, security.length);
                        writer.write(String.valueOf(TradingDataExport.this.fieldsFormat) + TradingDataExport.this.eol);
                        int i = 0;
                        while (i < security.length) {
                            monitor.setTaskName(security[i].getDescription());
                            if (security[i].getQuote() != null && security[i].getQuote().getDate() != null) {
                                writer.write(String.valueOf(security[i].getExchange()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getMarket()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(security[i].getSymbol()) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(dateFormat.format(security[i].getQuote().getDate())) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(security[i].getOpen() != null ? security[i].getOpen() : new Double(0.0))) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(security[i].getHigh() != null ? security[i].getHigh() : new Double(0.0))) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(security[i].getLow() != null ? security[i].getLow() : new Double(0.0))) + TradingDataExport.this.separator);
                                writer.write(String.valueOf(priceFormat.format(security[i].getClose() != null ? security[i].getClose() : new Double(0.0))) + TradingDataExport.this.separator);
                                writer.write(numberFormat.format(security[i].getQuote().getVolume()));
                                writer.write(TradingDataExport.this.eol);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    CorePlugin.logException((Exception)e);
                    return new Status(4, "org.eclipse.core.runtime", 0, Messages.TradingData_Export_ErrorMessage, (Throwable)e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }
}

