/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.export;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class TradeLogSelectionPage
extends WizardPage {
    public static final int CLIENT_WISE = 0;
    public static final int SYMBOL_WISE = 1;
    public static int SORT_ORDER = 0;
    Button all;
    Button selected;
    org.eclipse.swt.widgets.List list;
    Text txtFilePath;
    Button btnClientWise;
    Button btnSymbolWise;
    Button btnTxt;
    Button btnExcel;
    private String FILE_NAME = "Transaction_List_";
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (SORT_ORDER == 0) {
                return ((Order)arg0).getOrderClient().compareTo(((Order)arg1).getOrderClient());
            }
            if (SORT_ORDER == 1) {
                return ((Order)arg0).getSecurity().getSymbol().compareTo(((Order)arg1).getSecurity().getSymbol());
            }
            return 0;
        }
    };

    public TradeLogSelectionPage() {
        super("Export Trade Log");
        this.setTitle("Export Trade Log");
        this.setDescription("Export Trade Log to the local file system.");
        this.setPageComplete(false);
        this.FILE_NAME = String.valueOf(this.FILE_NAME) + this.format.format(new Date());
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        ObservableList trades = CorePlugin.getRepository().allTrades();
        Collections.sort(trades, this.comparator);
        this.all = new Button(content, 16);
        this.all.setText("Export All");
        this.all.setSelection(true);
        this.all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradeLogSelectionPage.this.list.setEnabled(false);
                TradeLogSelectionPage.this.enablePage();
            }
        });
        this.selected = new Button(content, 16);
        this.selected.setText("Select the trades to export");
        this.selected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradeLogSelectionPage.this.list.setEnabled(true);
                TradeLogSelectionPage.this.enablePage();
            }
        });
        Label label = new Label(content, 0);
        label.setText("Selec option to export data.");
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 2, true, false));
        this.btnClientWise = new Button(group, 16);
        this.btnClientWise.setText("Client Wise");
        this.btnClientWise.setSelection(true);
        this.btnClientWise.addSelectionListener(new SelectionListener((List)trades){
            private final /* synthetic */ List val$trades;
            {
                this.val$trades = list;
            }

            public void widgetSelected(SelectionEvent e) {
                SORT_ORDER = 0;
                Collections.sort(this.val$trades, TradeLogSelectionPage.this.comparator);
                TradeLogSelectionPage.this.updateList(this.val$trades);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnSymbolWise = new Button(group, 16);
        this.btnSymbolWise.setText("Symbol Wise");
        this.btnSymbolWise.addSelectionListener(new SelectionListener((List)trades){
            private final /* synthetic */ List val$trades;
            {
                this.val$trades = list;
            }

            public void widgetSelected(SelectionEvent e) {
                SORT_ORDER = 1;
                Collections.sort(this.val$trades, TradeLogSelectionPage.this.comparator);
                TradeLogSelectionPage.this.updateList(this.val$trades);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.list = new org.eclipse.swt.widgets.List(content, 2562);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.list.getItemHeight() * 10;
        this.list.setLayoutData((Object)gridData);
        this.list.setEnabled(!this.all.getSelection());
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradeLogSelectionPage.this.enablePage();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.ExportSelectionPage_DestinationLabel);
        group = new Composite(content, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 2, true, false));
        label = new Label(group, 0);
        label.setText("File Name:");
        this.txtFilePath = new Text(group, 2048);
        this.txtFilePath.setText(this.FILE_NAME);
        this.txtFilePath.setLayoutData((Object)new GridData(4, 2, true, false));
        this.txtFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TradeLogSelectionPage.this.enablePage();
            }
        });
        Button button = new Button(group, 8);
        button.setText("Browse..");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fd = new DirectoryDialog(TradeLogSelectionPage.this.getShell(), 8192);
                fd.setText("Save");
                String selected = fd.open();
                if (selected != null) {
                    File f = new File(selected, TradeLogSelectionPage.this.FILE_NAME);
                    TradeLogSelectionPage.this.txtFilePath.setText(f.getAbsolutePath());
                    TradeLogSelectionPage.this.enablePage();
                }
            }
        });
        label = new Label(group, 0);
        label.setText("Export As..");
        Composite btnGroup = new Composite(group, 0);
        btnGroup.setLayout((Layout)new GridLayout(2, false));
        this.btnTxt = new Button(btnGroup, 16);
        this.btnTxt.setText("Plain Text");
        this.btnTxt.setSelection(true);
        this.btnExcel = new Button(btnGroup, 16);
        this.btnExcel.setText("Excel File");
        this.updateList((List)trades);
        this.enablePage();
    }

    private void enablePage() {
        this.setPageComplete((this.list.getSelectionIndex() != -1 || this.all.getSelection()) && this.txtFilePath.getText().length() != 0 && this.list.getItemCount() > 0);
    }

    private void updateList(List orders) {
        this.list.removeAll();
        if (orders != null) {
            for (Order order : orders) {
                if (SORT_ORDER == 0) {
                    this.list.add(String.valueOf(order.getOrderClient()) + "  :  " + order.getSecurity().getSymbol() + "  :  " + order.getSecurity().getExchange() + "  :  " + order.getSecurity().getMarket());
                } else {
                    this.list.add(String.valueOf(order.getSecurity().getSymbol()) + "  :  " + order.getSecurity().getExchange() + "  :  " + order.getSecurity().getMarket() + "  :  " + order.getOrderClient());
                }
                this.list.setData(String.valueOf(this.list.getItemCount() - 1), (Object)order);
            }
        }
    }

    public Order[] getSelectedOrders() {
        if (this.selected.getSelection()) {
            int[] indices = this.list.getSelectionIndices();
            Order[] selection = new Order[indices.length];
            int i = 0;
            while (i < selection.length) {
                selection[i] = (Order)this.list.getData(String.valueOf(indices[i]));
                ++i;
            }
            return selection;
        }
        Order[] selection = new Order[this.list.getItemCount()];
        int i = 0;
        while (i < selection.length) {
            selection[i] = (Order)this.list.getData(String.valueOf(i));
            ++i;
        }
        return selection;
    }

    public String getFile() {
        if (this.btnExcel.getSelection()) {
            return String.valueOf(this.txtFilePath.getText()) + ".csv";
        }
        return String.valueOf(this.txtFilePath.getText()) + ".txt";
    }

    public int getDataToExport() {
        if (this.btnClientWise.getSelection()) {
            return 0;
        }
        if (this.btnSymbolWise.getSelection()) {
            return 1;
        }
        return -1;
    }
}

