/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.trading.ui.export.TradeLogSelectionPage;

public class TradeLogExport
extends Wizard
implements IExportWizard {
    TradeLogSelectionPage ordersSelectionPage = new TradeLogSelectionPage();
    String separator = ",";
    String eol = "\r\n";

    public TradeLogExport() {
        this.setWindowTitle("Export Trade Log");
        this.addPage((IWizardPage)this.ordersSelectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final Order[] orders = this.ordersSelectionPage.getSelectedOrders();
        final int export = this.ordersSelectionPage.getDataToExport();
        final String file = this.ordersSelectionPage.getFile();
        Job job = new Job("Job Name"){

            protected IStatus run(IProgressMonitor monitor) {
                SimpleDateFormat timeFormat = CorePlugin.getTimeFormat();
                String fieldsFormat = "Gateway ID, Market, Symbol, Client Account, Blank,Trade Time, Order Number, Status, Side,Executed Volume, Remaining Volume, Order Volume,Trade Price, Clearing Type, Trade Number, Blank,Blank,Value";
                try {
                    File ff = new File(file);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(ff));
                    char DOUBLE_QUOTES = '\"';
                    String blank = "";
                    if (export == 0 || export == 1) {
                        monitor.beginTask("Begin Task Client Wise name", orders.length);
                        writer.write(String.valueOf(fieldsFormat) + TradeLogExport.this.eol);
                        int i = 0;
                        while (i < orders.length) {
                            monitor.subTask(orders[i].getId());
                            Order order = orders[i];
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + Resources.memberIdentificationId + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + orders[i].getSecurity().getMarket() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + orders[i].getSecurity().getSymbol() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            if (!orders[i].getSubAccount().equals("")) {
                                writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getOrderClient() + "//" + orders[i].getSubAccount() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            } else {
                                writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getOrderClient() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            }
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + timeFormat.format(order.getDate()) + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getOrderId() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + orders[i].getStatus().toString() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + orders[i].getSide().toString() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getFilledQuantity() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + (orders[i].getQuantity() - orders[i].getFilledQuantity()) + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getQuantity() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getPrice() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + "dc" + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + orders[i].getTradeNumber() + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + DOUBLE_QUOTES + TradeLogExport.this.separator);
                            writer.write(String.valueOf(DOUBLE_QUOTES) + blank + (float)orders[i].getQuantity() * orders[i].getPrice() + DOUBLE_QUOTES);
                            writer.write(TradeLogExport.this.eol);
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    Event event = new Event();
                    event.setMessage("Trade Log Exported to : " + ff.getAbsolutePath());
                    event.setMessage_Type(13);
                    CorePlugin.getRepository().allEvents().add((Object)event);
                }
                catch (IOException e) {
                    CorePlugin.logException((Exception)e);
                    return new Status(4, "org.eclipse.core.runtime", 0, "Trade Log Export Error Message", (Throwable)e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }
}

