/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ITradingProvider;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.OrderRoute;
import pk.com.softech.tradingterminal.core.db.feed.TradeSource;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class TradeSourceOptions {
    protected Combo provider;
    protected Combo exchange;
    protected Text symbol;
    protected Combo account;
    protected Spinner quantity;

    public Composite createControls(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.TradeSourceOptions_Provider);
        label.setLayoutData((Object)new GridData(125, -1));
        this.provider = new Combo(content, 12);
        this.provider.setLayoutData((Object)new GridData(4, 1, true, false));
        this.provider.setVisibleItemCount(10);
        this.provider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradeSourceOptions.this.providerSelection();
                TradeSourceOptions.this.updateEnablement();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.TradeSourceOptions_Exchange);
        label.setLayoutData((Object)new GridData(125, -1));
        this.exchange = new Combo(content, 12);
        this.exchange.setLayoutData((Object)new GridData(4, 1, true, false));
        this.exchange.setVisibleItemCount(10);
        this.exchange.setEnabled(false);
        label = new Label(content, 0);
        label.setText(Messages.TradeSourceOptions_Symbol);
        label.setLayoutData((Object)new GridData(125, -1));
        this.symbol = new Text(content, 2048);
        this.symbol.setLayoutData((Object)new GridData(100, -1));
        label = new Label(content, 0);
        label.setText(Messages.TradeSourceOptions_Account);
        label.setLayoutData((Object)new GridData(125, -1));
        this.account = new Combo(content, 12);
        this.account.setLayoutData((Object)new GridData(4, 1, true, false));
        this.account.setVisibleItemCount(10);
        label = new Label(content, 0);
        label.setText(Messages.TradeSourceOptions_Quantity);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.quantity = new Spinner(content, 2048);
        this.quantity.setMinimum(1);
        this.quantity.setMaximum(999999999);
        this.quantity.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("pk.com.softech.tradingterminal.core.tradingProviders");
        if (extensionPoint != null) {
            List<IConfigurationElement> elements = Arrays.asList(extensionPoint.getConfigurationElements());
            Collections.sort(elements, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof IConfigurationElement && arg1 instanceof IConfigurationElement) {
                        String s0 = ((IConfigurationElement)arg0).getAttribute("name");
                        String s1 = ((IConfigurationElement)arg1).getAttribute("name");
                        return s0.compareTo(s1);
                    }
                    return 0;
                }
            });
            for (IConfigurationElement element : elements) {
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                this.provider.add(name);
                this.provider.setData(String.valueOf(this.provider.getItemCount() - 1), (Object)id);
            }
        } else {
            CorePlugin.logException((String)"Trading provider extension point is null");
        }
        ObservableList list = CorePlugin.getRepository().allAccounts();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Account)arg0).getDescription().compareTo(((Account)arg1).getDescription());
            }
        });
        for (Account s : list) {
            this.account.add(s.getDescription());
            this.account.setData(String.valueOf(this.account.getItemCount() - 1), (Object)s.getId());
        }
        this.updateEnablement();
        this.provider.setEnabled(false);
        this.exchange.setEnabled(false);
        this.symbol.setEnabled(false);
        this.account.setEnabled(false);
        this.quantity.setEnabled(false);
        return content;
    }

    public Composite createControls(Composite parent, TradeSource tradeSource) {
        Composite content = this.createControls(parent);
        if (tradeSource != null) {
            String[] items = this.provider.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.provider.getData(String.valueOf(i)) != null && this.provider.getData(String.valueOf(i)).equals(tradeSource.getTradingProviderId())) {
                    this.provider.select(i);
                    break;
                }
                ++i;
            }
            this.providerSelection();
            items = this.exchange.getItems();
            i = 0;
            while (i < items.length) {
                OrderRoute route = (OrderRoute)this.exchange.getData(this.exchange.getItem(i));
                if (route != null && route.getId().equals(tradeSource.getExchange())) {
                    this.exchange.select(i);
                    break;
                }
                ++i;
            }
            this.symbol.setText(tradeSource.getSymbol());
            items = this.account.getItems();
            i = 0;
            while (i < items.length) {
                if (this.account.getData(String.valueOf(i)) != null && this.account.getData(String.valueOf(i)).equals(tradeSource.getAccountId())) {
                    this.account.select(i);
                    break;
                }
                ++i;
            }
            this.quantity.setSelection(tradeSource.getQuantity());
        }
        this.updateEnablement();
        return content;
    }

    protected void providerSelection() {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        this.exchange.removeAll();
        this.exchange.add("");
        String providerId = (String)this.provider.getData(String.valueOf(this.provider.getSelectionIndex()));
        if (providerId != null && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint("pk.com.softech.tradingterminal.core.tradingProviders")) != null) {
            List<IConfigurationElement> plugins = Arrays.asList(extensionPoint.getConfigurationElements());
            for (IConfigurationElement element : plugins) {
                if (!element.getAttribute("id").equals(providerId)) continue;
                ITradingProvider source = CorePlugin.createTradeSourcePlugin((String)element.getAttribute("id"));
                OrderRoute r = new OrderRoute("1", "KSE");
                this.exchange.add(r.toString());
                this.exchange.setData(r.toString(), (Object)r);
                OrderRoute r1 = new OrderRoute("2", "LSE");
                this.exchange.add(r1.toString());
                this.exchange.setData(r1.toString(), (Object)r1);
                for (OrderRoute route : source.getRoutes()) {
                    this.exchange.add(route.toString());
                    this.exchange.setData(route.toString(), (Object)route);
                }
            }
        }
    }

    protected void updateEnablement() {
        boolean enable = this.provider.getData(String.valueOf(this.provider.getSelectionIndex())) != null;
        this.exchange.setEnabled(enable && this.exchange.getItemCount() > 1);
        this.symbol.setEnabled(enable);
        this.account.setEnabled(enable);
        this.quantity.setEnabled(enable);
    }

    public TradeSource getSource() {
        if (this.provider.getSelectionIndex() <= 0) {
            return null;
        }
        TradeSource newFeed = new TradeSource();
        newFeed.setTradingProviderId((String)this.provider.getData(String.valueOf(this.provider.getSelectionIndex())));
        if (this.exchange.getSelectionIndex() >= 1) {
            newFeed.setExchange(((OrderRoute)this.exchange.getData(this.exchange.getText())).getId());
        }
        newFeed.setSymbol(this.symbol.getText());
        if (this.account.getSelectionIndex() >= 1) {
            newFeed.setAccountId(Integer.valueOf(Integer.parseInt(this.account.getData(String.valueOf(this.account.getSelectionIndex())).toString())));
        }
        newFeed.setQuantity(this.quantity.getSelection());
        return newFeed;
    }
}

