/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;
import pk.com.softech.tradingterminal.core.ui.preferences.SplitsPage;
import pk.com.softech.tradingterminal.trading.ui.dialogs.DividendsPage;
import pk.com.softech.tradingterminal.trading.ui.dialogs.FeedOptions;
import pk.com.softech.tradingterminal.trading.ui.dialogs.IntradayDataOptions;
import pk.com.softech.tradingterminal.trading.ui.dialogs.TradeSourceOptions;

public class SecurityPropertiesDialog
extends PreferenceDialog {
    private Security security;

    public SecurityPropertiesDialog(Security security, Shell parentShell) {
        super(parentShell, new PreferenceManager());
        this.security = security;
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new GeneralPage()));
        PreferenceNode node = new PreferenceNode("feed", (IPreferencePage)new PreferencePage("Feeds"){

            protected Control createContents(Composite parent) {
                this.noDefaultAndApplyButton();
                return new Composite(parent, 0);
            }
        });
        this.getPreferenceManager().addToRoot((IPreferenceNode)node);
        node.add((IPreferenceNode)new PreferenceNode("quote", (IPreferencePage)new QuoteFeedPage()));
        node.add((IPreferenceNode)new PreferenceNode("level2", (IPreferencePage)new Level2FeedPage()));
        node.add((IPreferenceNode)new PreferenceNode("history", (IPreferencePage)new HistoryFeedPage()));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("trading", (IPreferencePage)new TradeSourcePage()));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("dividends", (IPreferencePage)new DividendsPage(security)));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("splits", (IPreferencePage)new SplitsPage(security)));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("notes", (IPreferencePage)new CommentsPage()));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(Messages.SecurityPropertiesDialog_Title) + this.security.getDescription());
    }

    protected void handleSave() {
        super.handleSave();
        CorePlugin.getRepository().save((PersistentObject)this.security);
    }

    private class CommentsPage
    extends PreferencePage {
        private Text text;

        public CommentsPage() {
            super("Notes");
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            this.text = new Text(content, 2050);
            this.text.setLayoutData((Object)new GridData(4, 4, true, true));
            this.text.setText(SecurityPropertiesDialog.this.security.getComment());
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setComment(this.text.getText());
            }
            return super.performOk();
        }
    }

    private class DataCollectorPage
    extends PreferencePage {
        IntradayDataOptions options;

        public DataCollectorPage() {
            super(Messages.SecurityPropertiesDialog_IntradayChartsPage);
            this.options = new IntradayDataOptions();
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = this.options.createControls(parent, SecurityPropertiesDialog.this.security);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                return this.options.saveSettings(SecurityPropertiesDialog.this.security);
            }
            return super.performOk();
        }
    }

    private class GeneralPage
    extends PreferencePage {
        private Text code;
        private Text securityDescription;
        private Combo currency;
        private Button clearHistory;
        private Button clearIntraday;

        public GeneralPage() {
            super(Messages.SecurityPropertiesDialog_GeneralPage);
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(content, 0);
            label.setText(Messages.SecurityPropertiesDialog_Code);
            label.setLayoutData((Object)new GridData(125, -1));
            this.code = new Text(content, 2048);
            this.code.setLayoutData((Object)new GridData(100, -1));
            this.code.setText(SecurityPropertiesDialog.this.security.getSymbol());
            this.code.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
            this.code.setEnabled(false);
            label = new Label(content, 0);
            label.setText(Messages.SecurityPropertiesDialog_Description);
            label.setLayoutData((Object)new GridData(125, -1));
            this.securityDescription = new Text(content, 2048);
            this.securityDescription.setLayoutData((Object)new GridData(4, 0, true, false));
            this.securityDescription.setText(SecurityPropertiesDialog.this.security.getDescription());
            this.securityDescription.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
            this.securityDescription.setEnabled(false);
            label = new Label(content, 0);
            label.setText(Messages.SecurityPropertiesDialog_Currency);
            label.setLayoutData((Object)new GridData(125, -1));
            this.currency = new Combo(content, 12);
            this.currency.setVisibleItemCount(10);
            this.currency.setEnabled(false);
            label = new Label(content, 0);
            label.setLayoutData((Object)new GridData(4, 1, true, true, 2, 1));
            this.clearHistory = new Button(content, 32);
            this.clearHistory.setText(Messages.SecurityPropertiesDialog_ClearHistory);
            this.clearHistory.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.clearIntraday = new Button(content, 32);
            this.clearIntraday.setText(Messages.SecurityPropertiesDialog_ClearIntraday);
            this.clearIntraday.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            List list = CurrencyConverter.getInstance().getCurrencies();
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((String)arg0).compareTo((String)arg1);
                }
            });
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                this.currency.add((String)iter.next());
            }
            this.currency.select(0);
            if (SecurityPropertiesDialog.this.security.getCurrency() != null) {
                this.currency.setText(SecurityPropertiesDialog.this.security.getCurrency().getCurrencyCode());
            }
            this.setValid(true);
            return content;
        }

        public boolean okToLeave() {
            if (this.code.getText().length() == 0) {
                return false;
            }
            if (this.securityDescription.getText().length() == 0) {
                return false;
            }
            return super.okToLeave();
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setSymbol(this.code.getText());
                SecurityPropertiesDialog.this.security.setDescription(this.securityDescription.getText());
                SecurityPropertiesDialog.this.security.setCurrency(this.currency.getText().length() != 0 ? Currency.getInstance(this.currency.getText()) : null);
                if (this.clearHistory.getSelection()) {
                    SecurityPropertiesDialog.this.security.deleteHistory();
                    SecurityPropertiesDialog.this.security.setChanged();
                }
                if (this.clearIntraday.getSelection()) {
                    SecurityPropertiesDialog.this.security.deleteIntradayHistory();
                    SecurityPropertiesDialog.this.security.setChanged();
                }
            }
            return super.performOk();
        }
    }

    private class HistoryFeedPage
    extends PreferencePage {
        FeedOptions options;

        public HistoryFeedPage() {
            super(Messages.SecurityPropertiesDialog_HistoryPage);
            this.options = new FeedOptions("history");
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = this.options.createControls(parent, SecurityPropertiesDialog.this.security.getHistoryFeed());
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setHistoryFeed(this.options.getFeed());
            }
            return super.performOk();
        }
    }

    private class Level2FeedPage
    extends PreferencePage {
        FeedOptions options;

        public Level2FeedPage() {
            super(Messages.SecurityPropertiesDialog_Level2Page);
            this.options = new FeedOptions("level2");
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = this.options.createControls(parent, SecurityPropertiesDialog.this.security.getLevel2Feed());
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setLevel2Feed(this.options.getFeed());
            }
            return super.performOk();
        }
    }

    private class QuoteFeedPage
    extends PreferencePage {
        FeedOptions options;

        public QuoteFeedPage() {
            super(Messages.SecurityPropertiesDialog_QuotePage);
            this.options = new FeedOptions("quote");
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = this.options.createControls(parent, SecurityPropertiesDialog.this.security.getQuoteFeed());
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setQuoteFeed(this.options.getFeed());
            }
            return super.performOk();
        }
    }

    private class TradeSourcePage
    extends PreferencePage {
        TradeSourceOptions options;

        public TradeSourcePage() {
            super(Messages.SecurityPropertiesDialog_TradeSourceTitle);
            this.options = new TradeSourceOptions();
            this.noDefaultAndApplyButton();
            this.setValid(false);
        }

        protected Control createContents(Composite parent) {
            Composite content = this.options.createControls(parent, SecurityPropertiesDialog.this.security.getTradeSource());
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                SecurityPropertiesDialog.this.security.setTradeSource(this.options.getSource());
            }
            return super.performOk();
        }
    }
}

