/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class SecurityPage
extends WizardPage {
    Text code;
    Text securityDescription;
    Combo currency;
    Combo market;
    Security security;

    public SecurityPage() {
        this(null);
    }

    public SecurityPage(Security security) {
        super("");
        this.setTitle(Messages.SecurityPage_Title);
        this.setDescription(Messages.SecurityPage_Description);
        this.setPageComplete(false);
        this.security = security;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.SecurityPage_CodeColumn);
        label.setLayoutData((Object)new GridData(125, -1));
        this.code = new Text(composite, 2048);
        this.code.setLayoutData((Object)new GridData(100, -1));
        if (this.security != null) {
            this.code.setText(this.security.getSymbol());
        }
        this.code.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SecurityPage.this.validatePage();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.SecurityPage_DescriptionColumn);
        label.setLayoutData((Object)new GridData(125, -1));
        this.securityDescription = new Text(composite, 2048);
        this.securityDescription.setLayoutData((Object)new GridData(4, 0, true, false));
        if (this.security != null) {
            this.securityDescription.setText(this.security.getDescription());
        }
        this.securityDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SecurityPage.this.validatePage();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.SecurityPage_MarketColumn);
        label.setLayoutData((Object)new GridData(125, -1));
        this.market = new Combo(composite, 12);
        this.market.setVisibleItemCount(10);
        this.market.add("");
        Enumeration enu = Resources.marketsData.keys();
        while (enu.hasMoreElements()) {
            String object = (String)enu.nextElement();
            this.market.add(object);
        }
        label = new Label(composite, 0);
        label.setText(Messages.SecurityPage_CurrencyColumn);
        label.setLayoutData((Object)new GridData(125, -1));
        this.currency = new Combo(composite, 12);
        this.currency.setVisibleItemCount(10);
        this.currency.add("");
        List list = CurrencyConverter.getInstance().getCurrencies();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.currency.add((String)iter.next());
        }
        if (this.security != null) {
            if (this.security.getCurrency() != null) {
                this.currency.setText(this.security.getCurrency().getCurrencyCode());
            }
        } else {
            this.currency.setText(Currency.getInstance(Locale.getDefault()).getCurrencyCode());
        }
        this.validatePage();
    }

    private void validatePage() {
        if (this.code.getText().length() == 0) {
            this.setPageComplete(false);
        } else if (this.securityDescription.getText().length() == 0) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public String getCode() {
        return this.code.getText();
    }

    public void setCode(String code) {
        this.code.setText(code);
        this.validatePage();
    }

    public Currency getCurrency() {
        if (this.currency.getText().length() != 0) {
            return Currency.getInstance(this.currency.getText());
        }
        return null;
    }

    public void setCurrency(Currency currency) {
        this.currency.setText(currency.getCurrencyCode());
        this.validatePage();
    }

    public String getSecurityDescription() {
        return this.securityDescription.getText();
    }

    public void setSecurityDescription(String securityDescription) {
        this.securityDescription.setText(securityDescription);
        this.validatePage();
    }

    public String getMarket() {
        return this.market.getText();
    }

    public void setMarket(Combo market) {
        this.market = market;
    }
}

