/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class SaveAsDialog
extends Dialog {
    private Text txtName;
    List watchlistItemsList;
    List listOfColumns;

    public SaveAsDialog(Shell shell, List list, List listOfColumns) {
        super(shell);
        this.watchlistItemsList = list;
        this.listOfColumns = listOfColumns;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Watchlist Save As");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createButton(parent, 0, "Save", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Name");
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(200, -1));
        this.txtName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SaveAsDialog.this.txtName.selectAll();
            }
        });
        this.txtName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SaveAsDialog.this.okPressed();
                }
            }
        });
        return super.createDialogArea(parent);
    }

    protected boolean canHandleShellCloseEvent() {
        CorePlugin.closeSockets();
        return super.canHandleShellCloseEvent();
    }

    public int open() {
        this.create();
        return super.open();
    }

    protected void okPressed() {
        Watchlist watchlist = new Watchlist();
        watchlist.setWatchlistType(0);
        String name = this.txtName.getText();
        if (name.equals(null) || name.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Name", (String)"Please enter some valid name");
            return;
        }
        watchlist.setDescription(name);
        watchlist.setUseDefaultCurrency(true);
        watchlist.setColumns(this.listOfColumns);
        watchlist.setItems(this.watchlistItemsList);
        if (watchlist != null && this.watchlistItemsList != null) {
            int i = 0;
            while (i < this.watchlistItemsList.size()) {
                WatchlistItem item = (WatchlistItem)this.watchlistItemsList.get(i);
                item.getSecurity();
                item.setParent(watchlist);
                ++i;
            }
            CorePlugin.getRepository().save((PersistentObject)watchlist);
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("pk.com.softech.tradingterminal.trading.watchlist", String.valueOf(watchlist.getId()), 1);
        }
        catch (PartInitException e) {
            CorePlugin.logException((Exception)((Object)e));
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

