/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class IntradayDataOptions {
    private Button enable;
    private Text beginTime;
    private Text endTime;
    private Text keepDays;
    private Button sun;
    private Button mon;
    private Button tue;
    private Button wed;
    private Button thu;
    private Button fri;
    private Button sat;
    private SimpleDateFormat timeFormat = CorePlugin.getTimeFormat();
    private Calendar time = Calendar.getInstance();

    public Composite createControls(Composite parent, Security security) {
        Composite control = this.createControls(parent);
        if (security != null) {
            this.enable.setSelection(security.isEnableDataCollector());
            this.time.set(11, security.getBeginTime() / 60);
            this.time.set(12, security.getBeginTime() % 60);
            this.beginTime.setText(this.timeFormat.format(this.time.getTime()));
            this.time.set(11, security.getEndTime() / 60);
            this.time.set(12, security.getEndTime() % 60);
            this.endTime.setText(this.timeFormat.format(this.time.getTime()));
            this.sun.setSelection((security.getWeekDays() & 1) != 0);
            this.mon.setSelection((security.getWeekDays() & 2) != 0);
            this.tue.setSelection((security.getWeekDays() & 4) != 0);
            this.wed.setSelection((security.getWeekDays() & 8) != 0);
            this.thu.setSelection((security.getWeekDays() & 0x10) != 0);
            this.fri.setSelection((security.getWeekDays() & 0x20) != 0);
            this.sat.setSelection((security.getWeekDays() & 0x40) != 0);
            this.keepDays.setText(String.valueOf(security.getKeepDays()));
        }
        return control;
    }

    public Composite createControls(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(125, -1));
        this.enable = new Button(content, 32);
        this.enable.setText(Messages.IntradayDataOptions_Enable);
        label = new Label(content, 0);
        label.setText(Messages.IntradayDataOptions_Begin);
        label.setLayoutData((Object)new GridData(125, -1));
        this.beginTime = new Text(content, 2048);
        this.beginTime.setLayoutData((Object)new GridData(60, -1));
        this.beginTime.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    IntradayDataOptions.this.time.setTime(IntradayDataOptions.this.timeFormat.parse(IntradayDataOptions.this.beginTime.getText()));
                    IntradayDataOptions.this.beginTime.setText(IntradayDataOptions.this.timeFormat.format(IntradayDataOptions.this.time.getTime()));
                }
                catch (ParseException e1) {
                    CorePlugin.logException((Exception)e1);
                }
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.IntradayDataOptions_End);
        label.setLayoutData((Object)new GridData(125, -1));
        this.endTime = new Text(content, 2048);
        this.endTime.setLayoutData((Object)new GridData(60, -1));
        this.endTime.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    IntradayDataOptions.this.time.setTime(IntradayDataOptions.this.timeFormat.parse(IntradayDataOptions.this.endTime.getText()));
                    IntradayDataOptions.this.endTime.setText(IntradayDataOptions.this.timeFormat.format(IntradayDataOptions.this.time.getTime()));
                }
                catch (ParseException e1) {
                    CorePlugin.logException((Exception)e1);
                }
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.IntradayDataOptions_WeekDays);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.sun = new Button(group, 32);
        this.sun.setText(Messages.IntradayDataOptions_Sun);
        this.mon = new Button(group, 32);
        this.mon.setText(Messages.IntradayDataOptions_Mon);
        this.tue = new Button(group, 32);
        this.tue.setText(Messages.IntradayDataOptions_Tue);
        this.wed = new Button(group, 32);
        this.wed.setText(Messages.IntradayDataOptions_Wed);
        this.thu = new Button(group, 32);
        this.thu.setText(Messages.IntradayDataOptions_Thu);
        this.fri = new Button(group, 32);
        this.fri.setText(Messages.IntradayDataOptions_Fri);
        this.sat = new Button(group, 32);
        this.sat.setText(Messages.IntradayDataOptions_Sat);
        label = new Label(content, 0);
        label.setText(Messages.IntradayDataOptions_KeepDays);
        label.setLayoutData((Object)new GridData(125, -1));
        this.keepDays = new Text(content, 2048);
        this.keepDays.setLayoutData((Object)new GridData(60, -1));
        this.enable.setSelection(false);
        this.time.set(11, 9);
        this.time.set(12, 30);
        this.beginTime.setText(this.timeFormat.format(this.time.getTime()));
        this.time.set(11, 17);
        this.time.set(12, 30);
        this.endTime.setText(this.timeFormat.format(this.time.getTime()));
        this.sun.setSelection(false);
        this.mon.setSelection(true);
        this.tue.setSelection(true);
        this.wed.setSelection(true);
        this.thu.setSelection(true);
        this.fri.setSelection(true);
        this.sat.setSelection(false);
        this.keepDays.setText(String.valueOf(1));
        return content;
    }

    public boolean saveSettings(Security security) {
        security.setEnableDataCollector(this.enable.getSelection());
        int weekdays = 0;
        if (this.sun.getSelection()) {
            weekdays |= 1;
        }
        if (this.mon.getSelection()) {
            weekdays |= 2;
        }
        if (this.tue.getSelection()) {
            weekdays |= 4;
        }
        if (this.wed.getSelection()) {
            weekdays |= 8;
        }
        if (this.thu.getSelection()) {
            weekdays |= 0x10;
        }
        if (this.fri.getSelection()) {
            weekdays |= 0x20;
        }
        if (this.sat.getSelection()) {
            weekdays |= 0x40;
        }
        security.setWeekDays(weekdays);
        security.setKeepDays(Integer.parseInt(this.keepDays.getText()));
        try {
            this.time.setTime(this.timeFormat.parse(this.beginTime.getText()));
            security.setBeginTime(this.time.get(11) * 60 + this.time.get(12));
            this.time.setTime(this.timeFormat.parse(this.endTime.getText()));
            security.setEndTime(this.time.get(11) * 60 + this.time.get(12));
        }
        catch (ParseException e) {
            CorePlugin.logException((Exception)e);
            return false;
        }
        return true;
    }
}

