/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.db.feed.FeedSource;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class FeedOptions {
    protected Combo feed;
    protected Combo exchange;
    protected Text symbol;
    protected String categoryId;

    public FeedOptions(String categoryId) {
        this.categoryId = categoryId;
    }

    public Composite createControls(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.FeedOptions_Feed);
        label.setLayoutData((Object)new GridData(125, -1));
        this.feed = new Combo(content, 12);
        this.feed.setLayoutData((Object)new GridData(4, 1, true, false));
        this.feed.setVisibleItemCount(10);
        this.feed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedOptions.this.updateFeedExchanges();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.FeedOptions_Exchange);
        label.setLayoutData((Object)new GridData(125, -1));
        this.exchange = new Combo(content, 12);
        this.exchange.setLayoutData((Object)new GridData(4, 1, true, false));
        this.exchange.setVisibleItemCount(10);
        this.exchange.add("");
        this.exchange.setEnabled(false);
        label = new Label(content, 0);
        label.setText(Messages.FeedOptions_Symbol);
        label.setLayoutData((Object)new GridData(125, -1));
        this.symbol = new Text(content, 2048);
        this.symbol.setLayoutData((Object)new GridData(100, -1));
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("pk.com.softech.tradingterminal.core.feeds");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            List<IConfigurationElement> plugins = Arrays.asList(elements);
            Collections.sort(plugins, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof IConfigurationElement && arg1 instanceof IConfigurationElement) {
                        String s0 = ((IConfigurationElement)arg0).getAttribute("name");
                        String s1 = ((IConfigurationElement)arg1).getAttribute("name");
                        return s0.compareTo(s1);
                    }
                    return 0;
                }
            });
            for (IConfigurationElement element : plugins) {
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                IConfigurationElement[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().equals(this.categoryId)) {
                        this.feed.add(name);
                        this.feed.setData(String.valueOf(this.feed.getItemCount() - 1), (Object)id);
                    }
                    ++i;
                }
            }
        }
        return content;
    }

    public Composite createControls(Composite parent, FeedSource feedSource) {
        Composite content = this.createControls(parent);
        if (feedSource != null) {
            String[] items = this.feed.getItems();
            int i = 0;
            while (i < items.length) {
                if (this.feed.getData(String.valueOf(i)) != null && this.feed.getData(String.valueOf(i)).equals(feedSource.getId())) {
                    this.feed.select(i);
                    this.updateFeedExchanges();
                    break;
                }
                ++i;
            }
            items = this.exchange.getItems();
            i = 0;
            while (i < items.length) {
                if (this.exchange.getData(String.valueOf(i)) != null && this.exchange.getData(String.valueOf(i)).equals(feedSource.getExchange())) {
                    this.exchange.select(i);
                    break;
                }
                ++i;
            }
            this.symbol.setText(feedSource.getSymbol());
        }
        return content;
    }

    protected void updateFeedExchanges() {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        this.exchange.removeAll();
        this.exchange.add("");
        String feedId = (String)this.feed.getData(String.valueOf(this.feed.getSelectionIndex()));
        if (feedId != null && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint("pk.com.softech.tradingterminal.core.feeds")) != null) {
            List<IConfigurationElement> plugins = Arrays.asList(extensionPoint.getConfigurationElements());
            for (IConfigurationElement element : plugins) {
                if (!element.getAttribute("id").equals(feedId)) continue;
                IConfigurationElement[] children = element.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().equals(this.categoryId)) {
                        IConfigurationElement[] exchanges = children[i].getChildren();
                        int x = 0;
                        while (x < exchanges.length) {
                            if (exchanges[x].getName().equals("exchange")) {
                                this.exchange.setData(String.valueOf(this.exchange.getItemCount()), (Object)exchanges[x].getAttribute("id"));
                                this.exchange.add(exchanges[x].getAttribute("name"));
                            }
                            ++x;
                        }
                    }
                    ++i;
                }
            }
        }
        this.exchange.setEnabled(this.exchange.getItemCount() > 1);
    }

    public FeedSource getFeed() {
        if (this.feed.getSelectionIndex() < 0) {
            return null;
        }
        FeedSource newFeed = new FeedSource();
        newFeed.setId((String)this.feed.getData(String.valueOf(this.feed.getSelectionIndex())));
        newFeed.setExchange((String)this.exchange.getData(String.valueOf(this.exchange.getSelectionIndex())));
        newFeed.setSymbol(this.symbol.getText());
        return newFeed;
    }
}

