/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.ui.dialogs;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Dividend;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;
import pk.com.softech.tradingterminal.core.ui.widgets.EditableTable;
import pk.com.softech.tradingterminal.core.ui.widgets.EditableTableColumn;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableItem;

public class DividendsPage
extends PreferencePage {
    Table table;
    Button add;
    Button delete;
    Security security;
    NumberFormat numberFormatter = NumberFormat.getInstance();
    SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
    SimpleDateFormat dateParse = CorePlugin.getDateParse();

    public DividendsPage(Security security) {
        super(Messages.DividendsPage_Title);
        this.noDefaultAndApplyButton();
        this.setValid(false);
        this.security = security;
        this.numberFormatter.setGroupingUsed(true);
        this.numberFormatter.setMinimumIntegerDigits(1);
        this.numberFormatter.setMinimumFractionDigits(4);
        this.numberFormatter.setMaximumFractionDigits(4);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new EditableTable(content, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DividendsPage.this.delete.setEnabled(DividendsPage.this.table.getSelectionCount() != 0);
            }
        });
        EditableTableColumn column = new EditableTableColumn(this.table, 0);
        column.setText(Messages.DividendsPage_Date);
        column.setWidth(70);
        column = new EditableTableColumn(this.table, 0);
        column.setText(Messages.DividendsPage_Value);
        column.setWidth(70);
        Composite buttonsComposite = new Composite(content, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        this.add = new Button(buttonsComposite, 8);
        this.add.setText(Messages.DividendsPage_Add);
        this.setButtonLayoutData(this.add);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableTableItem tableItem = new EditableTableItem(DividendsPage.this.table, 0);
                tableItem.setText(0, DividendsPage.this.dateFormat.format(Calendar.getInstance().getTime()));
                tableItem.setText(1, DividendsPage.this.numberFormatter.format(0.01));
            }
        });
        this.delete = new Button(buttonsComposite, 8);
        this.delete.setText(Messages.DividendsPage_Delete);
        this.setButtonLayoutData(this.delete);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = DividendsPage.this.table.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].dispose();
                    ++i;
                }
                DividendsPage.this.delete.setEnabled(DividendsPage.this.table.getSelectionCount() != 0);
            }
        });
        if (this.security != null) {
            for (Dividend dividend : this.security.getDividends()) {
                EditableTableItem tableItem = new EditableTableItem(this.table, 0);
                tableItem.setText(0, this.dateFormat.format(dividend.getDate()));
                tableItem.setText(1, this.numberFormatter.format(dividend.getValue()));
            }
        }
        this.setValid(true);
        return content;
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.security.setDividends(this.getDividends());
            this.security.setChanged();
        }
        return super.performOk();
    }

    public List getDividends() {
        ArrayList<Dividend> list = new ArrayList<Dividend>();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            try {
                Dividend dividend = new Dividend();
                dividend.setDate(this.dateParse.parse(items[i].getText(0)));
                dividend.setValue(this.numberFormatter.parse(items[i].getText(1)).doubleValue());
                list.add(dividend);
            }
            catch (Exception e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)e);
            }
            ++i;
        }
        return list;
    }

    class EditableTableItem
    extends TableItem
    implements IEditableItem {
        public EditableTableItem(Table parent, int style, int index) {
            super(parent, style, index);
        }

        public EditableTableItem(Table parent, int style) {
            super(parent, style);
        }

        protected void checkSubclass() {
        }

        public boolean canEdit(int index) {
            return true;
        }

        public boolean isEditable() {
            return true;
        }

        public void itemEdited(int index, String text) {
            if (index == 0) {
                try {
                    Date date = DividendsPage.this.dateParse.parse(text);
                    this.setText(index, DividendsPage.this.dateFormat.format(date));
                }
                catch (Exception e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)e);
                    this.setText(index, DividendsPage.this.dateFormat.format(Calendar.getInstance().getTime()));
                }
            } else if (index == 1) {
                try {
                    double value = DividendsPage.this.numberFormatter.parse(text).doubleValue();
                    this.setText(index, DividendsPage.this.numberFormatter.format(value));
                }
                catch (Exception e) {
                    LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)e);
                }
            }
        }
    }
}

