/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.systems;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.trading.TradingSystemPluginPreferencePage;

public class PatternTradingPreferences
extends TradingSystemPluginPreferencePage {
    private Combo pattern;
    private Combo period;
    private Spinner bars;

    @Override
    public void init(Security security, Map params) {
        super.init(security, params);
    }

    @Override
    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Pattern");
        label.setLayoutData((Object)new GridData(125, -1));
        this.pattern = new Combo(content, 8);
        this.pattern.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label(content, 0);
        label.setText("Period");
        label.setLayoutData((Object)new GridData(125, -1));
        this.period = new Combo(content, 8);
        this.period.add("Daily");
        this.period.add("Weekly");
        this.period.add("Monthly");
        if (this.getParameters().get("period") != null) {
            this.period.select(Integer.parseInt((String)this.getParameters().get("period")));
        } else {
            this.period.select(1);
        }
        label = new Label(content, 0);
        label.setText("Bars");
        label.setLayoutData((Object)new GridData(125, -1));
        this.bars = new Spinner(content, 2048);
        this.bars.setMinimum(0);
        this.bars.setMaximum(9999);
        if (this.getParameters().get("bars") != null) {
            this.bars.setSelection(Integer.parseInt((String)this.getParameters().get("bars")));
        }
        for (IConfigurationElement element : CorePlugin.getAllPatternPlugins()) {
            this.pattern.add(element.getAttribute("name"));
            this.pattern.setData(element.getAttribute("name"), (Object)element.getAttribute("id"));
            if (!element.getAttribute("id").equals(this.getParameters().get("pattern"))) continue;
            this.pattern.select(this.pattern.getItemCount() - 1);
        }
        if (this.pattern.getSelectionIndex() == -1) {
            this.pattern.select(0);
        }
        return content;
    }

    @Override
    public void performOk() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.pattern != null) {
            params.put("pattern", (String)this.pattern.getData(this.pattern.getText()));
        }
        if (this.period != null) {
            params.put("period", String.valueOf(this.period.getSelectionIndex()));
        }
        if (this.bars != null) {
            params.put("bars", String.valueOf(this.bars.getSelection()));
        }
        this.setParameters(params);
    }
}

