/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.systems;

import java.util.Map;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.BarData;
import pk.com.softech.tradingterminal.trading.TradingSystemPlugin;

public class PatternTrading
extends TradingSystemPlugin {
    public static final String PLUGIN_ID = "pk.com.softech.tradingterminal.trading.pattern";
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    private String patternId;
    private int period = 9;

    @Override
    public void run() {
        this.setSignal(0);
        BarData barData = new BarData(this.getSecurity().getHistory().getList());
        if (this.period != 8) {
            barData = barData.getCompressed(this.period);
        }
        IPattern pattern = CorePlugin.createPatternPlugin((String)this.patternId);
        pattern.init(this.getSecurity());
        int i = 0;
        while (i < barData.size()) {
            pattern.add(barData.get(i));
            ++i;
        }
        Sentiment sentiment = pattern.getSentiment();
        if (sentiment.equals((Object)Sentiment.BULLISH)) {
            this.fireOpenLongSignal();
        } else if (sentiment.equals((Object)Sentiment.BEARISH)) {
            this.fireCloseLongSignal();
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void setParameters(Map parameters) {
        if (parameters.get("pattern") != null) {
            this.patternId = (String)parameters.get("pattern");
        }
        if (parameters.get("period") != null) {
            switch (Integer.parseInt((String)parameters.get("period"))) {
                case 0: {
                    this.period = 8;
                    break;
                }
                case 1: {
                    this.period = 9;
                    break;
                }
                case 2: {
                    this.period = 10;
                }
            }
        }
    }
}

