/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.preference;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Utility;

public class StartupShutdownPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button updateHistoryData;
    private Button updateOnce;
    private Button updateNews;
    private Button updateSecurities;
    private Button updateSecuritiesOnce;
    private Button minimizeToTray;
    private Button runInBackground;
    private Button confirmExit;
    private Combo cmbTimeZone;
    private Button btnEnableEventsLimit;
    private Spinner spnEventsLimit;
    private Button showAnnouncements;
    List list = Utility.getTimeZones();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore pref = CorePlugin.getDefault().getPreferenceStore();
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.updateHistoryData = new Button(content, 32);
        this.updateHistoryData.setText("Update history data on startup");
        this.updateHistoryData.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.updateHistoryData.setSelection(pref.getBoolean("UPDATE_HISTORY"));
        this.updateHistoryData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupShutdownPreferencesPage.this.updateOnce.setEnabled(StartupShutdownPreferencesPage.this.updateHistoryData.getSelection());
            }
        });
        this.updateHistoryData.setEnabled(false);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(13, 0));
        this.updateOnce = new Button(content, 32);
        this.updateOnce.setText("Update once per day");
        this.updateOnce.setLayoutData((Object)new GridData(1, 1, false, false));
        this.updateOnce.setSelection(pref.getBoolean("UPDATE_HISTORY_ONCE"));
        this.updateOnce.setEnabled(pref.getBoolean("UPDATE_HISTORY"));
        this.updateOnce.setEnabled(false);
        this.updateNews = new Button(content, 32);
        this.updateNews.setText("Update news heads on startup");
        this.updateNews.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.updateNews.setSelection(pref.getBoolean("UPDATE_NEWS"));
        this.minimizeToTray = new Button(content, 32);
        this.minimizeToTray.setText("Minimize to system tray");
        this.minimizeToTray.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.minimizeToTray.setSelection(pref.getBoolean("MINIMIZE_TO_TRAY"));
        this.runInBackground = new Button(content, 32);
        this.runInBackground.setText("Run in background");
        this.runInBackground.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.runInBackground.setSelection(PlatformUI.getPreferenceStore().getBoolean("RUN_IN_BACKGROUND"));
        this.showAnnouncements = new Button(content, 32);
        this.showAnnouncements.setText("Show Live Announcements on startup");
        this.showAnnouncements.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.showAnnouncements.setSelection(pref.getBoolean("PREFS_SHOW_ANNOUNCEMENTS"));
        this.updateSecurities = new Button(content, 32);
        this.updateSecurities.setText("Refresh securities on startup");
        this.updateSecurities.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.updateSecurities.setSelection(pref.getBoolean("PREFS_UPDATE_SECURITY"));
        this.updateSecurities.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartupShutdownPreferencesPage.this.updateSecuritiesOnce.setEnabled(StartupShutdownPreferencesPage.this.updateSecurities.getSelection());
            }
        });
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(13, 0));
        this.updateSecuritiesOnce = new Button(content, 32);
        this.updateSecuritiesOnce.setText("Update once per day");
        this.updateSecuritiesOnce.setLayoutData((Object)new GridData(1, 1, false, false));
        this.updateSecuritiesOnce.setSelection(pref.getBoolean("PREFS_UPDATE_SECURITY_ONCE"));
        this.updateSecuritiesOnce.setEnabled(pref.getBoolean("PREFS_UPDATE_SECURITY"));
        this.confirmExit = new Button(content, 32);
        this.confirmExit.setText("Confirm exit when closing");
        this.confirmExit.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.confirmExit.setSelection(pref.getBoolean("PROMPT_ON_EXIT"));
        label = new Label(content, 0);
        label.setText("Time Zone");
        this.cmbTimeZone = new Combo(content, 2056);
        int i = 0;
        while (i < this.list.size()) {
            this.cmbTimeZone.add(((Utility.TimeZoneID)this.list.get(i)).toString());
            ++i;
        }
        this.cmbTimeZone.select(this.list.indexOf(new Utility.TimeZoneID(0, pref.getString("TIME_ZONE"))));
        this.btnEnableEventsLimit = new Button(content, 32);
        this.btnEnableEventsLimit.setSelection(pref.getBoolean("ENABLE_EVENTS_LIMITS"));
        this.btnEnableEventsLimit.setText("Limit no of events in Events View");
        this.spnEventsLimit = new Spinner(content, 2048);
        this.spnEventsLimit.setValues(pref.getInt("EVENTS_LIMITS"), 0, 1000000, 0, 1, 1);
        return content;
    }

    public boolean performOk() {
        IPreferenceStore pref = CorePlugin.getDefault().getPreferenceStore();
        pref.setValue("PROMPT_ON_EXIT", this.confirmExit.getSelection());
        pref.setValue("MINIMIZE_TO_TRAY", this.minimizeToTray.getSelection());
        PlatformUI.getPreferenceStore().setValue("RUN_IN_BACKGROUND", this.runInBackground.getSelection());
        pref.setValue("UPDATE_HISTORY", this.updateHistoryData.getSelection());
        pref.setValue("UPDATE_HISTORY_ONCE", this.updateOnce.getSelection());
        pref.setValue("UPDATE_NEWS", this.updateNews.getSelection());
        pref.setValue("PREFS_SHOW_ANNOUNCEMENTS", this.showAnnouncements.getSelection());
        pref.setValue("PREFS_UPDATE_SECURITY", this.updateSecurities.getSelection());
        pref.setValue("PREFS_UPDATE_SECURITY_ONCE", this.updateSecuritiesOnce.getSelection());
        try {
            pref.setValue("TIME_ZONE", ((Utility.TimeZoneID)this.list.get((int)this.cmbTimeZone.getSelectionIndex())).id);
        }
        catch (Exception exception) {}
        pref.setValue("ENABLE_EVENTS_LIMITS", this.btnEnableEventsLimit.getSelection());
        pref.setValue("EVENTS_LIMITS", this.spnEventsLimit.getText());
        return super.performOk();
    }
}

