/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class LockedSymbolsSettingPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button btnLockSoundAlert;
    Text txtLockSoundFile;
    Button btnBrowseLockSoundFile;
    Button btnLockNotificationAlert;
    Button btnLockTimeable;
    Spinner lockNotificationTime;
    Button btnLockCloseable;
    Button btnLockPopupAlert;
    Button btnAddToEvents;

    public LockedSymbolsSettingPage() {
    }

    public LockedSymbolsSettingPage(String title) {
        super(title);
    }

    public LockedSymbolsSettingPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Group cmpNorth = new Group(parent, 16);
        cmpNorth.setLayout((Layout)new GridLayout(4, false));
        cmpNorth.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cmpNorth.setText("Sound Alert Setting");
        this.btnLockSoundAlert = new Button((Composite)cmpNorth, 32);
        this.btnLockSoundAlert.setText("Enable lock confirmation");
        this.btnLockSoundAlert.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        Label label = new Label((Composite)cmpNorth, 0);
        label.setLayoutData((Object)new GridData(15, 0));
        new Label((Composite)cmpNorth, 0).setText("Sound File Name");
        this.txtLockSoundFile = new Text((Composite)cmpNorth, 2048);
        this.txtLockSoundFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtLockSoundFile.setEnabled(false);
        this.btnBrowseLockSoundFile = new Button((Composite)cmpNorth, 8);
        this.btnBrowseLockSoundFile.setText("Browse");
        this.btnBrowseLockSoundFile.setEnabled(false);
        Group cmpCenter = new Group(parent, 16);
        cmpCenter.setLayout((Layout)new GridLayout(1, false));
        cmpCenter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cmpCenter.setText("Notification Alert Setting");
        Composite cmpCenterTop = new Composite((Composite)cmpCenter, 0);
        cmpCenterTop.setLayout((Layout)new GridLayout(4, false));
        cmpCenterTop.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnLockNotificationAlert = new Button(cmpCenterTop, 32);
        this.btnLockNotificationAlert.setText("Enable lock confirmation");
        this.btnLockNotificationAlert.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.btnLockNotificationAlert.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                if (btn.getSelection()) {
                    LockedSymbolsSettingPage.this.btnLockCloseable.setEnabled(true);
                    LockedSymbolsSettingPage.this.btnLockTimeable.setEnabled(true);
                } else {
                    LockedSymbolsSettingPage.this.btnLockCloseable.setEnabled(false);
                    LockedSymbolsSettingPage.this.btnLockTimeable.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(cmpCenterTop, 0);
        label.setLayoutData((Object)new GridData(15, 0));
        this.btnLockTimeable = new Button(cmpCenterTop, 16);
        this.btnLockTimeable.setText("Notification Time");
        this.lockNotificationTime = new Spinner(cmpCenterTop, 2048);
        this.lockNotificationTime.setMinimum(5);
        this.lockNotificationTime.setMaximum(60);
        this.lockNotificationTime.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.lockNotificationTime.setToolTipText("");
        label = new Label(cmpCenterTop, 0);
        label.setText("seconds");
        label = new Label(cmpCenterTop, 0);
        label.setLayoutData((Object)new GridData(15, 0));
        this.btnLockCloseable = new Button(cmpCenterTop, 16);
        this.btnLockCloseable.setText("Block on open");
        this.btnLockCloseable.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        Group cmpSouth = new Group(parent, 16);
        cmpSouth.setLayout((Layout)new GridLayout(4, false));
        cmpSouth.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        cmpSouth.setText("PopUp Dialog Setting");
        label = new Label((Composite)cmpSouth, 0);
        label.setLayoutData((Object)new GridData(15, 0));
        this.btnLockPopupAlert = new Button((Composite)cmpSouth, 32);
        this.btnLockPopupAlert.setText("Enable Lock Confirmation");
        this.btnLockPopupAlert.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(15, 0));
        this.btnAddToEvents = new Button(parent, 32);
        this.btnAddToEvents.setText("Add to Events View");
        this.btnAddToEvents.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 4, 1));
        this.loadDefaultValues();
        return parent;
    }

    private void loadDefaultValues() {
        this.btnLockSoundAlert.setSelection(this.getPreferenceStore().getBoolean("LOCKED_SOUND_ALERT_BOOL"));
        this.txtLockSoundFile.setText(this.getPreferenceStore().getString("LOCKED_SOUND_ALERT_FILE_PATH"));
        this.btnLockNotificationAlert.setSelection(this.getPreferenceStore().getBoolean("LOCKED_NOTIFICATION_ALERT_BOOL"));
        this.btnLockTimeable.setSelection(this.getPreferenceStore().getBoolean("LOCKED_NOTIFICATION_CLOSEABLE_BOOL"));
        this.lockNotificationTime.setSelection(this.getPreferenceStore().getInt("LOCKED_NOTIFICATION_TIME"));
        this.btnLockCloseable.setSelection(!this.getPreferenceStore().getBoolean("LOCKED_NOTIFICATION_CLOSEABLE_BOOL"));
        if (!this.getPreferenceStore().getBoolean("LOCKED_NOTIFICATION_ALERT_BOOL")) {
            this.btnLockCloseable.setEnabled(false);
            this.btnLockTimeable.setEnabled(false);
        } else {
            this.btnLockCloseable.setEnabled(true);
            this.btnLockTimeable.setEnabled(true);
        }
        this.btnLockPopupAlert.setSelection(this.getPreferenceStore().getBoolean("LOCKED_POPUP_BOOL"));
        this.btnAddToEvents.setSelection(this.getPreferenceStore().getBoolean("LOCKED_ADD_TO_EVENTS_BOOL "));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("LOCKED_SOUND_ALERT_BOOL", this.btnLockSoundAlert.getSelection());
        this.getPreferenceStore().setValue("LOCKED_SOUND_ALERT_FILE_PATH", this.txtLockSoundFile.getText());
        this.getPreferenceStore().setValue("LOCKED_NOTIFICATION_ALERT_BOOL", this.btnLockNotificationAlert.getSelection());
        if (this.btnLockNotificationAlert.getSelection()) {
            if (this.btnLockTimeable.getSelection()) {
                this.getPreferenceStore().setValue("LOCKED_NOTIFICATION_TIME", this.lockNotificationTime.getSelection());
                this.getPreferenceStore().setValue("LOCKED_NOTIFICATION_CLOSEABLE_BOOL", true);
            } else {
                this.getPreferenceStore().setValue("LOCKED_NOTIFICATION_CLOSEABLE_BOOL", false);
            }
        }
        this.getPreferenceStore().setValue("LOCKED_POPUP_BOOL", this.btnLockPopupAlert.getSelection());
        this.getPreferenceStore().setValue("LOCKED_ADD_TO_EVENTS_BOOL ", this.btnAddToEvents.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.btnLockSoundAlert.setSelection(false);
        this.txtLockSoundFile.setText("data/ding.wav");
        this.btnLockNotificationAlert.setSelection(false);
        this.lockNotificationTime.setSelection(5);
        this.btnLockCloseable.setSelection(false);
        this.btnLockTimeable.setSelection(true);
        this.btnLockPopupAlert.setSelection(false);
        this.btnAddToEvents.setSelection(false);
    }
}

