/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.util.Observable;
import java.util.Observer;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.trading.portfolio.AccountTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.IStructuredViewerListener;

public class PositionTreeNode
implements Observer {
    PortfolioPosition value;
    AccountTreeNode parent;
    Quote quote;
    IStructuredViewerListener listener;

    PositionTreeNode(AccountTreeNode parent, PortfolioPosition position) {
        this.parent = parent;
        this.value = position;
        this.value.getSecurity().addObserver((Observer)this);
        this.value.getSecurity().getQuoteMonitor().addObserver((Observer)this);
        this.quote = this.value.getSecurity().getQuote();
    }

    public void dispose() {
        this.value.getSecurity().deleteObserver((Observer)this);
        this.value.getSecurity().getQuoteMonitor().deleteObserver((Observer)this);
        this.listener = null;
    }

    public AccountTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.quote = this.value.getSecurity().getQuote();
        if (this.listener != null) {
            this.listener.update(this, null);
        }
    }

    public void setListener(IStructuredViewerListener listener) {
        this.listener = listener;
    }
}

