/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.ui.AccountGroupSelection;
import pk.com.softech.tradingterminal.core.ui.AccountSelection;
import pk.com.softech.tradingterminal.core.ui.NullSelection;
import pk.com.softech.tradingterminal.core.ui.PortfolioPositionSelection;
import pk.com.softech.tradingterminal.core.ui.SelectionProvider;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.AccountTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.PortfolioContentProvider;
import pk.com.softech.tradingterminal.trading.portfolio.PortfolioInput;
import pk.com.softech.tradingterminal.trading.portfolio.PortfolioLabelProvider;
import pk.com.softech.tradingterminal.trading.portfolio.PositionTreeNode;

public class PortfolioView
extends ViewPart {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.views.portfolio";
    public static final String PREFS_COLUMN_SIZE = "COLUMN_SIZE";
    public static final String PREFS_EXPANDED_GROUPS = "EXPANDED_GROUPS";
    public static final String PREFS_EXPANDED_ACCOUNTS = "EXPANDED_ACCOUNTS";
    PreferenceStore preferences;
    Set expandedGroups = new HashSet();
    Set expandedAccounts = new HashSet();
    Tree tree;
    TreeViewer viewer;
    Color negativeForeground = new Color(null, 240, 0, 0);
    Color positiveForeground = new Color(null, 0, 192, 0);
    Font boldFont;
    SelectionProvider selectionProvider = new SelectionProvider();
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < PortfolioView.this.tree.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(PortfolioView.this.tree.getColumn(i).getWidth())) + ";");
                ++i;
            }
            PortfolioView.this.preferences.setValue(PortfolioView.PREFS_COLUMN_SIZE, sizes.toString());
        }
    };
    Job updateJob = new Job("Portfolio Build"){

        protected IStatus run(IProgressMonitor monitor) {
            block2: {
                final PortfolioInput input = new PortfolioInput();
                try {
                    PortfolioView.this.tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).PortfolioView.this.tree.isDisposed()) {
                                (this).PortfolioView.this.viewer.setInput((Object)input);
                                PortfolioView.this.restoreExpandedStatus();
                                PortfolioView.this.updateSelection();
                            }
                        }
                    });
                }
                catch (SWTException e) {
                    if (e.code == 24) break block2;
                    throw e;
                }
            }
            return Status.OK_STATUS;
        }
    };
    DropTargetAdapter dropTargetListener = new DropTargetAdapter(){

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
        }

        public void drop(DropTargetEvent event) {
            event.detail = 1;
            Account account = null;
            if (event.item instanceof TreeItem) {
                Object node = event.item.getData();
                if (node instanceof PositionTreeNode) {
                    account = ((PositionTreeNode)node).getParent().value;
                }
                if (node instanceof AccountTreeNode) {
                    account = ((AccountTreeNode)node).value;
                }
            }
            if (account != null && SecurityTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Security[] securities = (Security[])event.data;
                int i = 0;
                while (i < securities.length) {
                    ++i;
                }
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.preferences = new PreferenceStore(TradingPlugin.getDefault().getStateLocation().append("portfolio.prefs").toOSString());
        try {
            this.preferences.load();
        }
        catch (Exception exception) {}
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        site.getActionBars().updateActionBars();
        site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 65538);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(false);
        TreeColumn column = new TreeColumn(this.tree, 0);
        column.addControlListener(this.columnControlListener);
        column = new TreeColumn(this.tree, 131072);
        column.setText("Position");
        column.addControlListener(this.columnControlListener);
        column = new TreeColumn(this.tree, 131072);
        column.setText("Price");
        column.addControlListener(this.columnControlListener);
        column = new TreeColumn(this.tree, 131072);
        column.setText("Last");
        column.addControlListener(this.columnControlListener);
        column = new TreeColumn(this.tree, 131072);
        column.setText("Value");
        column.addControlListener(this.columnControlListener);
        column = new TreeColumn(this.tree, 131072);
        column.setText("Gain / Loss");
        column.addControlListener(this.columnControlListener);
        FontData fd = this.tree.getFont().getFontData()[0];
        this.boldFont = new Font(null, fd.getName(), fd.getHeight(), 1);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new PortfolioContentProvider());
        PortfolioLabelProvider labelProvider = new PortfolioLabelProvider();
        labelProvider.boldFont = this.boldFont;
        labelProvider.negativeForeground = this.negativeForeground;
        labelProvider.positiveForeground = this.positiveForeground;
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PortfolioView.this.updateSelection();
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (element instanceof AccountGroupTreeNode) {
                    PortfolioView.this.expandedGroups.remove(((AccountGroupTreeNode)element).value.getId());
                }
                if (element instanceof AccountTreeNode) {
                    PortfolioView.this.expandedAccounts.remove(((AccountTreeNode)element).value.getId());
                }
                PortfolioView.this.saveExpandedStatus();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (element instanceof AccountGroupTreeNode) {
                    PortfolioView.this.expandedGroups.add(((AccountGroupTreeNode)element).value.getId());
                }
                if (element instanceof AccountTreeNode) {
                    PortfolioView.this.expandedAccounts.add(((AccountTreeNode)element).value.getId());
                }
                PortfolioView.this.saveExpandedStatus();
            }
        });
        this.viewer.addDropSupport(1, new Transfer[]{SecurityTransfer.getInstance()}, (DropTargetListener)this.dropTargetListener);
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("bottom"));
            }
        });
        this.tree.setMenu(menuMgr.createContextMenu((Control)this.tree));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        String[] sizes = this.preferences.getString(PREFS_COLUMN_SIZE).split(";");
        int i = 0;
        while (i < this.tree.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                this.tree.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                this.tree.getColumn(i).setWidth(i == 0 ? 100 : 75);
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.tree.getColumn(this.tree.getColumnCount() - 1).pack();
        }
        this.updateJob.setUser(false);
        this.updateJob.schedule();
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        this.boldFont.dispose();
        try {
            this.preferences.save();
        }
        catch (Exception e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)e);
        }
        super.dispose();
    }

    void updateSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj instanceof AccountTreeNode) {
                this.selectionProvider.setSelection((ISelection)new AccountSelection(((AccountTreeNode)obj).value));
            } else if (obj instanceof AccountGroupTreeNode) {
                this.selectionProvider.setSelection((ISelection)new AccountGroupSelection(((AccountGroupTreeNode)obj).value));
            } else if (obj instanceof PositionTreeNode) {
                Account account = ((PositionTreeNode)obj).parent.value;
                PortfolioPosition position = ((PositionTreeNode)obj).value;
                this.selectionProvider.setSelection((ISelection)new PortfolioPositionSelection(account, position));
            } else {
                this.selectionProvider.setSelection((ISelection)new NullSelection());
            }
        } else {
            this.selectionProvider.setSelection((ISelection)new NullSelection());
        }
    }

    void saveExpandedStatus() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.expandedGroups.iterator();
        while (iter.hasNext()) {
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(String.valueOf(iter.next()));
        }
        this.preferences.setValue(PREFS_EXPANDED_GROUPS, sb.toString());
        sb = new StringBuffer();
        iter = this.expandedAccounts.iterator();
        while (iter.hasNext()) {
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(String.valueOf(iter.next()));
        }
        this.preferences.setValue(PREFS_EXPANDED_ACCOUNTS, sb.toString());
    }

    void restoreExpandedStatus() {
        Object element;
        Integer id;
        PortfolioInput input = (PortfolioInput)this.viewer.getInput();
        String[] values = this.preferences.getString(PREFS_EXPANDED_GROUPS).split(";");
        int i = 0;
        while (i < values.length) {
            try {
                id = new Integer(values[i]);
                element = input.getAccountGroupNode(id);
                if (element != null) {
                    this.expandedGroups.add(id);
                    this.viewer.setExpandedState(element, true);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        values = this.preferences.getString(PREFS_EXPANDED_ACCOUNTS).split(";");
        i = 0;
        while (i < values.length) {
            try {
                id = new Integer(values[i]);
                element = input.getAccountNode(id);
                if (element != null) {
                    this.expandedAccounts.add(id);
                    this.viewer.setExpandedState(element, true);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

