/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.AccountTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.PositionTreeNode;

public class PortfolioLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
IFontProvider {
    NumberFormat numberFormat = NumberFormat.getInstance();
    NumberFormat priceFormat = NumberFormat.getInstance();
    NumberFormat valueFormat = NumberFormat.getInstance();
    NumberFormat percentageFormat = NumberFormat.getInstance();
    Color negativeForeground;
    Color positiveForeground;
    Font boldFont;

    public PortfolioLabelProvider() {
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(0);
        this.priceFormat.setGroupingUsed(true);
        this.priceFormat.setMinimumIntegerDigits(1);
        this.priceFormat.setMinimumFractionDigits(4);
        this.priceFormat.setMaximumFractionDigits(4);
        this.percentageFormat.setGroupingUsed(true);
        this.percentageFormat.setMinimumIntegerDigits(1);
        this.percentageFormat.setMinimumFractionDigits(2);
        this.percentageFormat.setMaximumFractionDigits(2);
        this.valueFormat.setGroupingUsed(true);
        this.valueFormat.setMinimumIntegerDigits(1);
        this.valueFormat.setMinimumFractionDigits(2);
        this.valueFormat.setMaximumFractionDigits(2);
    }

    public String getText(Object element) {
        if (element instanceof AccountGroupTreeNode) {
            return ((AccountGroupTreeNode)element).value.getDescription();
        }
        if (element instanceof AccountTreeNode) {
            return ((AccountTreeNode)element).value.getDescription();
        }
        if (element instanceof PositionTreeNode) {
            return ((PositionTreeNode)element).value.getSecurity().getDescription();
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AccountGroupTreeNode && columnIndex == 0) {
            return ((AccountGroupTreeNode)element).value.getDescription();
        }
        if (element instanceof AccountTreeNode && columnIndex == 0) {
            return ((AccountTreeNode)element).value.getDescription();
        }
        if (element instanceof PositionTreeNode) {
            PortfolioPosition position = ((PositionTreeNode)element).value;
            Quote quote = ((PositionTreeNode)element).quote;
            switch (columnIndex) {
                case 0: {
                    return position.getSecurity().toString();
                }
                case 1: {
                    return this.numberFormat.format(position.getQuantity());
                }
                case 2: {
                    return this.priceFormat.format(position.getPrice());
                }
                case 3: {
                    return quote == null ? "" : this.priceFormat.format(quote.getLast());
                }
                case 4: {
                    return quote == null ? "" : this.valueFormat.format(position.getMarketValue());
                }
                case 5: {
                    double gain = position.getQuantity() > 0 ? position.getMarketValue() - position.getValue() : position.getValue() - position.getMarketValue();
                    String s1 = this.valueFormat.format(gain);
                    String s2 = this.percentageFormat.format(gain / position.getValue() * 100.0);
                    if (gain > 0.0) {
                        return "+" + s1 + " (+" + s2 + "%)";
                    }
                    return String.valueOf(s1) + " (" + s2 + "%)";
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof PositionTreeNode) {
            PortfolioPosition position = ((PositionTreeNode)element).value;
            if (columnIndex == 5) {
                double gain;
                double d = gain = position.getQuantity() > 0 ? position.getMarketValue() - position.getValue() : position.getValue() - position.getMarketValue();
                if (gain > 0.0) {
                    return this.positiveForeground;
                }
                if (gain < 0.0) {
                    return this.negativeForeground;
                }
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof AccountGroupTreeNode || element instanceof AccountTreeNode) {
            return this.boldFont;
        }
        return null;
    }
}

