/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.AccountGroup;
import pk.com.softech.tradingterminal.trading.portfolio.AccountComparator;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupComparator;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.AccountTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.IStructuredViewerListener;

public class PortfolioInput {
    Object[] elements = new Object[0];
    List groups = new ArrayList();
    List accounts = new ArrayList();
    IStructuredViewerListener listener;
    private ICollectionObserver groupsCollectionObserver = new ICollectionObserver(){

        public void itemAdded(Object o) {
            AccountGroup newGroup = (AccountGroup)o;
            Object[] items = PortfolioInput.this.groups.toArray();
            int i = 0;
            while (i < items.length) {
                AccountGroup arg1 = ((AccountGroupTreeNode)items[i]).value;
                if (AccountGroupComparator.getInstance().compare(newGroup, arg1) < 0) {
                    PortfolioInput.this.groups.add(i, new AccountGroupTreeNode(null, newGroup));
                    PortfolioInput.this.updateChildrens();
                    return;
                }
                ++i;
            }
            PortfolioInput.this.groups.add(new AccountGroupTreeNode(null, newGroup));
            PortfolioInput.this.updateChildrens();
        }

        public void itemRemoved(Object o) {
            AccountGroup newGroup = (AccountGroup)o;
            Object[] items = PortfolioInput.this.groups.toArray();
            int i = 0;
            while (i < items.length) {
                if (newGroup == ((AccountGroupTreeNode)items[i]).value) {
                    ((AccountGroupTreeNode)items[i]).dispose();
                    PortfolioInput.this.groups.remove(i);
                    PortfolioInput.this.updateChildrens();
                    return;
                }
                ++i;
            }
        }
    };
    private ICollectionObserver accountsCollectionObserver = new ICollectionObserver(){

        public void itemAdded(Object o) {
            Account newAccount = (Account)o;
            Object[] items = PortfolioInput.this.accounts.toArray();
            int i = 0;
            while (i < items.length) {
                Account arg1 = ((AccountTreeNode)items[i]).value;
                if (AccountComparator.getInstance().compare(newAccount, arg1) < 0) {
                    PortfolioInput.this.accounts.add(i, new AccountTreeNode(null, newAccount));
                    PortfolioInput.this.updateChildrens();
                    return;
                }
                ++i;
            }
            PortfolioInput.this.accounts.add(new AccountTreeNode(null, newAccount));
            PortfolioInput.this.updateChildrens();
        }

        public void itemRemoved(Object o) {
            Account newAccount = (Account)o;
            Object[] items = PortfolioInput.this.accounts.toArray();
            int i = 0;
            while (i < items.length) {
                if (newAccount == ((AccountTreeNode)items[i]).value) {
                    ((AccountTreeNode)items[i]).dispose();
                    PortfolioInput.this.accounts.remove(i);
                    PortfolioInput.this.updateChildrens();
                    return;
                }
                ++i;
            }
        }
    };

    public PortfolioInput() {
        ArrayList list = new ArrayList(CorePlugin.getRepository().allAccountGroups());
        Collections.sort(list, AccountGroupComparator.getInstance());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.groups.add(new AccountGroupTreeNode(null, (AccountGroup)iter.next()));
        }
        list = new ArrayList(CorePlugin.getRepository().allAccounts());
        Collections.sort(list, AccountComparator.getInstance());
        iter = list.iterator();
        while (iter.hasNext()) {
            try {
                System.out.println(list.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.accounts.add(new AccountTreeNode(null, (Account)iter.next()));
        }
        this.updateChildrens();
        CorePlugin.getRepository().allAccountGroups().addCollectionObserver(this.groupsCollectionObserver);
        CorePlugin.getRepository().allAccounts().addCollectionObserver(this.accountsCollectionObserver);
    }

    public void dispose() {
        CorePlugin.getRepository().allAccountGroups().removeCollectionObserver(this.groupsCollectionObserver);
        CorePlugin.getRepository().allAccounts().removeCollectionObserver(this.accountsCollectionObserver);
        this.listener = null;
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            ((AccountGroupTreeNode)items[i]).dispose();
            ++i;
        }
        items = this.accounts.toArray();
        i = 0;
        while (i < items.length) {
            ((AccountTreeNode)items[i]).dispose();
            ++i;
        }
    }

    public Object[] getElements() {
        return this.elements;
    }

    public void setListener(IStructuredViewerListener listener) {
        this.listener = listener;
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            ((AccountGroupTreeNode)items[i]).setListener(listener);
            ++i;
        }
        items = this.accounts.toArray();
        i = 0;
        while (i < items.length) {
            ((AccountTreeNode)items[i]).setListener(listener);
            ++i;
        }
    }

    void updateChildrens() {
        ArrayList list = new ArrayList();
        list.addAll(this.groups);
        list.addAll(this.accounts);
        this.elements = list.toArray();
    }

    public AccountTreeNode getAccountNode(Integer id) {
        Object[] items = this.accounts.toArray();
        int i = 0;
        while (i < items.length) {
            if (((AccountTreeNode)items[i]).value.getId().equals(id)) {
                return (AccountTreeNode)items[i];
            }
            ++i;
        }
        return null;
    }

    public AccountGroupTreeNode getAccountGroupNode(Integer id) {
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            AccountGroupTreeNode node = ((AccountGroupTreeNode)items[i]).getAccountGroupNode(id);
            if (node != null) {
                return node;
            }
            ++i;
        }
        return null;
    }
}

