/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.PortfolioPosition;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.IStructuredViewerListener;
import pk.com.softech.tradingterminal.trading.portfolio.PositionTreeNode;

public class AccountTreeNode
implements Observer {
    Account value;
    AccountGroupTreeNode parent;
    List childs = new ArrayList();
    IStructuredViewerListener listener;

    AccountTreeNode(AccountGroupTreeNode parent, Account account) {
        this.parent = parent;
        this.value = account;
        Iterator iter = this.value.getPortfolio().iterator();
        while (iter.hasNext()) {
            this.childs.add(new PositionTreeNode(this, (PortfolioPosition)iter.next()));
        }
        this.value.addObserver((Observer)this);
    }

    public void dispose() {
        this.value.deleteObserver((Observer)this);
        this.listener = null;
        Object[] items = this.childs.toArray();
        int i = 0;
        while (i < items.length) {
            ((PositionTreeNode)items[i]).dispose();
            ++i;
        }
    }

    public AccountGroupTreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.childs.size() != 0;
    }

    public Object[] getChildren() {
        return this.childs.toArray();
    }

    @Override
    public void update(Observable o, Object arg) {
        Object[] items = this.childs.toArray();
        int i = 0;
        while (i < items.length) {
            ((PositionTreeNode)items[i]).dispose();
            ++i;
        }
        this.childs.clear();
        Iterator iter = this.value.getPortfolio().iterator();
        while (iter.hasNext()) {
            this.childs.add(new PositionTreeNode(this, (PortfolioPosition)iter.next()));
        }
        items = this.childs.toArray();
        i = 0;
        while (i < items.length) {
            ((PositionTreeNode)items[i]).setListener(this.listener);
            ++i;
        }
        if (this.listener != null) {
            this.listener.refresh(this);
        }
    }

    public void setListener(IStructuredViewerListener listener) {
        this.listener = listener;
        Object[] items = this.childs.toArray();
        int i = 0;
        while (i < items.length) {
            ((PositionTreeNode)items[i]).setListener(listener);
            ++i;
        }
    }
}

