/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.portfolio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.AccountGroup;
import pk.com.softech.tradingterminal.trading.portfolio.AccountComparator;
import pk.com.softech.tradingterminal.trading.portfolio.AccountGroupComparator;
import pk.com.softech.tradingterminal.trading.portfolio.AccountTreeNode;
import pk.com.softech.tradingterminal.trading.portfolio.IStructuredViewerListener;

public class AccountGroupTreeNode {
    AccountGroup value;
    AccountGroupTreeNode parent;
    Object[] childrens = new Object[0];
    List groups = new ArrayList();
    List accounts = new ArrayList();
    IStructuredViewerListener listener;
    private ICollectionObserver groupsCollectionObserver = new ICollectionObserver(){

        public void itemAdded(Object o) {
            AccountGroup newGroup = (AccountGroup)o;
            Object[] items = AccountGroupTreeNode.this.groups.toArray();
            int i = 0;
            while (i < items.length) {
                AccountGroup arg1 = ((AccountGroupTreeNode)items[i]).value;
                if (AccountGroupComparator.getInstance().compare(newGroup, arg1) < 0) {
                    AccountGroupTreeNode.this.groups.add(i, new AccountGroupTreeNode(AccountGroupTreeNode.this, newGroup));
                    AccountGroupTreeNode.this.updateChildrens();
                    if (AccountGroupTreeNode.this.listener != null) {
                        AccountGroupTreeNode.this.listener.refresh(this);
                    }
                    return;
                }
                ++i;
            }
            AccountGroupTreeNode.this.groups.add(new AccountGroupTreeNode(AccountGroupTreeNode.this, newGroup));
            AccountGroupTreeNode.this.updateChildrens();
            if (AccountGroupTreeNode.this.listener != null) {
                AccountGroupTreeNode.this.listener.refresh(this);
            }
        }

        public void itemRemoved(Object o) {
            AccountGroup newGroup = (AccountGroup)o;
            Object[] items = AccountGroupTreeNode.this.groups.toArray();
            int i = 0;
            while (i < items.length) {
                if (newGroup == ((AccountGroupTreeNode)items[i]).value) {
                    ((AccountGroupTreeNode)items[i]).dispose();
                    AccountGroupTreeNode.this.groups.remove(i);
                    AccountGroupTreeNode.this.updateChildrens();
                    if (AccountGroupTreeNode.this.listener != null) {
                        AccountGroupTreeNode.this.listener.refresh(this);
                    }
                    return;
                }
                ++i;
            }
        }
    };
    private ICollectionObserver accountsCollectionObserver = new ICollectionObserver(){

        public void itemAdded(Object o) {
            Account newAccount = (Account)o;
            Object[] items = AccountGroupTreeNode.this.accounts.toArray();
            int i = 0;
            while (i < items.length) {
                Account arg1 = ((AccountTreeNode)items[i]).value;
                if (AccountComparator.getInstance().compare(newAccount, arg1) < 0) {
                    AccountGroupTreeNode.this.accounts.add(i, new AccountTreeNode(AccountGroupTreeNode.this, newAccount));
                    AccountGroupTreeNode.this.updateChildrens();
                    if (AccountGroupTreeNode.this.listener != null) {
                        AccountGroupTreeNode.this.listener.refresh(this);
                    }
                    return;
                }
                ++i;
            }
            AccountGroupTreeNode.this.accounts.add(new AccountTreeNode(AccountGroupTreeNode.this, newAccount));
            AccountGroupTreeNode.this.updateChildrens();
            if (AccountGroupTreeNode.this.listener != null) {
                AccountGroupTreeNode.this.listener.refresh(this);
            }
        }

        public void itemRemoved(Object o) {
            Account newAccount = (Account)o;
            Object[] items = AccountGroupTreeNode.this.accounts.toArray();
            int i = 0;
            while (i < items.length) {
                if (newAccount == ((AccountTreeNode)items[i]).value) {
                    ((AccountTreeNode)items[i]).dispose();
                    AccountGroupTreeNode.this.accounts.remove(i);
                    AccountGroupTreeNode.this.updateChildrens();
                    if (AccountGroupTreeNode.this.listener != null) {
                        AccountGroupTreeNode.this.listener.refresh(this);
                    }
                    return;
                }
                ++i;
            }
        }
    };

    AccountGroupTreeNode(AccountGroupTreeNode parent, AccountGroup group) {
        this.parent = parent;
        this.value = group;
        ArrayList list = new ArrayList(this.value.getGroups());
        Collections.sort(list, AccountGroupComparator.getInstance());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.groups.add(new AccountGroupTreeNode(this, (AccountGroup)iter.next()));
        }
        list = new ArrayList(this.value.getAccounts());
        Collections.sort(list, AccountComparator.getInstance());
        iter = list.iterator();
        while (iter.hasNext()) {
            this.accounts.add(new AccountTreeNode(this, (Account)iter.next()));
        }
        this.updateChildrens();
        this.value.getGroups().addCollectionObserver(this.groupsCollectionObserver);
        this.value.getAccounts().addCollectionObserver(this.accountsCollectionObserver);
    }

    public void dispose() {
        this.value.getGroups().removeCollectionObserver(this.groupsCollectionObserver);
        this.value.getAccounts().removeCollectionObserver(this.accountsCollectionObserver);
        this.listener = null;
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            ((AccountGroupTreeNode)items[i]).dispose();
            ++i;
        }
        items = this.accounts.toArray();
        i = 0;
        while (i < items.length) {
            ((AccountTreeNode)items[i]).dispose();
            ++i;
        }
    }

    public AccountGroupTreeNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.childrens.length != 0;
    }

    public Object[] getChildren() {
        return this.childrens;
    }

    public void setListener(IStructuredViewerListener listener) {
        this.listener = listener;
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            ((AccountGroupTreeNode)items[i]).setListener(listener);
            ++i;
        }
        items = this.accounts.toArray();
        i = 0;
        while (i < items.length) {
            ((AccountTreeNode)items[i]).setListener(listener);
            ++i;
        }
    }

    void updateChildrens() {
        ArrayList list = new ArrayList();
        list.addAll(this.groups);
        list.addAll(this.accounts);
        this.childrens = list.toArray();
    }

    public AccountTreeNode getAccountNode(Integer id) {
        Object[] items = this.accounts.toArray();
        int i = 0;
        while (i < items.length) {
            if (((AccountTreeNode)items[i]).value.getId().equals(id)) {
                return (AccountTreeNode)items[i];
            }
            ++i;
        }
        return null;
    }

    public AccountGroupTreeNode getAccountGroupNode(Integer id) {
        if (this.value.getId().equals(id)) {
            return this;
        }
        Object[] items = this.groups.toArray();
        int i = 0;
        while (i < items.length) {
            AccountGroupTreeNode node = ((AccountGroupTreeNode)items[i]).getAccountGroupNode(id);
            if (node != null) {
                return node;
            }
            ++i;
        }
        return null;
    }
}

