/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.patterns;

import java.util.ArrayList;
import java.util.List;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;

public class ThreeBarRule
implements IPattern {
    List bars = new ArrayList();
    int minimumBars = 3;
    int maximumBars = 3;
    Sentiment sentiment = Sentiment.INVALID;

    public void init(Security security) {
        this.bars = new ArrayList();
        this.sentiment = Sentiment.INVALID;
    }

    public void add(Bar bar) {
        this.bars.add(bar);
        if (this.bars.size() > this.maximumBars) {
            this.bars.remove(0);
        }
        if (this.bars.size() >= this.minimumBars) {
            this.sentiment = Sentiment.NEUTRAL;
            Bar[] recs = this.bars.toArray(new Bar[this.bars.size()]);
            if (recs[0].getClose() >= recs[0].getLow() + (recs[0].getHigh() - recs[0].getLow()) / 2.0 && recs[1].getClose() >= recs[1].getLow() + (recs[1].getHigh() - recs[1].getLow()) / 2.0 && this.closesInTopQuarter(recs[2])) {
                this.sentiment = Sentiment.BULLISH;
            } else if (recs[0].getClose() <= recs[0].getLow() + (recs[0].getHigh() - recs[0].getLow()) / 2.0 && recs[1].getClose() <= recs[1].getLow() + (recs[1].getHigh() - recs[1].getLow()) / 2.0 && recs[2].getClose() <= recs[2].getLow() + (recs[2].getHigh() - recs[2].getLow()) / 4.0) {
                this.sentiment = Sentiment.BEARISH;
            }
        }
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    private boolean closesInTopQuarter(Bar rec) {
        return rec.getClose() >= rec.getLow() + (rec.getHigh() - rec.getLow()) * 3.0 / 4.0;
    }
}

