/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.patterns;

import java.util.ArrayList;
import java.util.List;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;

public class LindahlSellRule
implements IPattern {
    List bars = new ArrayList();
    int minimumBars = 9;
    int maximumBars = 9;
    Sentiment sentiment = Sentiment.INVALID;

    public void init(Security security) {
        this.bars = new ArrayList();
        this.sentiment = Sentiment.INVALID;
    }

    public void add(Bar bar) {
        this.bars.add(bar);
        if (this.bars.size() > this.maximumBars) {
            this.bars.remove(0);
        }
        if (this.bars.size() >= this.minimumBars) {
            this.sentiment = Sentiment.NEUTRAL;
            Bar[] recs = this.bars.toArray(new Bar[this.bars.size()]);
            int a = 0;
            int b = 1;
            int d = 1;
            int e = 1;
            double ahigh = recs[a].getHigh();
            int size = Math.min(8, recs.length);
            while (b < size) {
                if (recs[a].getLow() > recs[b].getLow() && recs[b].getHigh() < ahigh) break;
                ++b;
            }
            d = b + 1;
            while (d < size) {
                if (recs[d].getHigh() < ahigh && recs[d - 1].getHigh() < ahigh && recs[d - 1].getHigh() < recs[d].getHigh()) break;
                ++d;
            }
            e = d + 1;
            while (e < size) {
                Bar rece = recs[e];
                Bar recf = recs[e - 1];
                if (rece.getLow() < recf.getLow() && rece.getClose() < recf.getClose() && rece.getClose() < rece.getOpen() && rece.getHigh() < ahigh && recf.getHigh() < ahigh) {
                    this.sentiment = Sentiment.BEARISH;
                    return;
                }
                ++e;
            }
        }
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }
}

