/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.patterns;

import java.util.ArrayList;
import java.util.List;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;

public class LindahlBuyRule
implements IPattern {
    List bars = new ArrayList();
    int minimumBars = 9;
    int maximumBars = 9;
    Sentiment sentiment = Sentiment.INVALID;

    public void init(Security security) {
        this.bars = new ArrayList();
        this.sentiment = Sentiment.INVALID;
    }

    public void add(Bar bar) {
        this.bars.add(bar);
        if (this.bars.size() > this.maximumBars) {
            this.bars.remove(0);
        }
        if (this.bars.size() >= this.minimumBars) {
            this.sentiment = Sentiment.NEUTRAL;
            Bar[] recs = this.bars.toArray(new Bar[this.bars.size()]);
            int a = 0;
            int b = 1;
            int d = 1;
            int e = 1;
            while (b < 9 && b < recs.length) {
                if (recs[a].getHigh() < recs[b].getHigh() && recs[b].getLow() > recs[a].getLow()) break;
                ++b;
            }
            d = b + 1;
            while (d < 9 && d < recs.length) {
                if (recs[d - 1].getLow() > recs[d].getLow() && recs[d].getLow() > recs[a].getLow() && recs[d - 1].getLow() > recs[a].getLow()) break;
                ++d;
            }
            e = d + 1;
            while (e < 9 && e < recs.length) {
                if (recs[e].getHigh() > recs[e - 1].getHigh() && recs[e].getClose() > recs[e - 1].getClose() && recs[e].getClose() > recs[e].getOpen() && recs[e].getLow() > recs[a].getLow() && recs[e - 1].getLow() > recs[a].getLow()) {
                    this.sentiment = Sentiment.BULLISH;
                    return;
                }
                ++e;
            }
        }
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }
}

