/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.patterns;

import java.util.ArrayList;
import java.util.List;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;

public class HighLowReversal
implements IPattern {
    List bars = new ArrayList();
    int minimumBars = 2;
    int maximumBars = 2;
    Sentiment sentiment = Sentiment.INVALID;
    double difference = 0.05;

    public void init(Security security) {
        this.bars = new ArrayList();
        this.sentiment = Sentiment.INVALID;
    }

    public void add(Bar bar) {
        this.bars.add(bar);
        if (this.bars.size() > this.maximumBars) {
            this.bars.remove(0);
        }
        if (this.bars.size() >= this.minimumBars) {
            this.sentiment = Sentiment.NEUTRAL;
            Bar[] recs = this.bars.toArray(new Bar[this.bars.size()]);
            if (recs[0].getClose() >= recs[0].getHigh() - this.difference && recs[1].getClose() <= recs[1].getLow() + this.difference) {
                this.sentiment = Sentiment.BEARISH;
            } else if (recs[1].getClose() >= recs[1].getHigh() - this.difference && recs[0].getClose() <= recs[0].getLow() + this.difference) {
                this.sentiment = Sentiment.BULLISH;
            }
        }
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }
}

