/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.patterns;

import java.util.ArrayList;
import java.util.List;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Security;

public class DoubleReversalRule
implements IPattern {
    boolean[] _reversals = new boolean[3];
    List bars = new ArrayList();
    int minimumBars = 6;
    int maximumBars = 6;
    Sentiment sentiment = Sentiment.INVALID;

    public void init(Security security) {
        this.bars = new ArrayList();
        this.sentiment = Sentiment.INVALID;
    }

    public void add(Bar bar) {
        this.bars.add(bar);
        if (this.bars.size() > this.maximumBars) {
            this.bars.remove(0);
        }
        if (this.bars.size() >= this.minimumBars) {
            this.sentiment = Sentiment.NEUTRAL;
            Bar[] recs = this.bars.toArray(new Bar[this.bars.size()]);
            boolean[] reversals = new boolean[6];
            int end = (recs.length < 6 ? recs.length : 6) - 1;
            int[] complete = new int[2];
            int n = 0;
            while (n < end) {
                Bar rn = recs[n];
                Bar rn1 = recs[n + 1];
                double[] high = new double[]{rn.getHigh(), rn1.getHigh()};
                double[] low = new double[]{rn.getLow(), rn1.getLow()};
                double[] dArray = new double[]{rn.getClose(), rn1.getClose()};
                double[] close = dArray;
                if (close[1] >= high[1] - 0.05 && close[0] <= low[0] + 0.05) {
                    reversals[0] = true;
                    if (n + 1 > complete[0]) {
                        complete[0] = n + 1;
                    }
                } else if (close[0] >= high[0] - 0.05 && close[1] <= low[0] + 0.05) {
                    reversals[3] = true;
                    if (n + 1 > complete[1]) {
                        complete[1] = n + 1;
                    }
                }
                if (low[1] < low[0] && close[1] > close[0]) {
                    reversals[1] = true;
                    if (n + 1 > complete[0]) {
                        complete[0] = n + 1;
                    }
                } else if (high[1] >= high[0] && close[1] <= close[0]) {
                    reversals[4] = true;
                    if (n + 1 > complete[1]) {
                        complete[1] = n + 1;
                    }
                }
                if (high[0] < high[1] && low[0] > low[1]) {
                    if (close[1] >= high[0]) {
                        reversals[2] = true;
                        if (n + 1 > complete[0]) {
                            complete[0] = n + 1;
                        }
                    }
                } else if (high[0] < high[1] && low[0] > low[1] && close[1] <= low[0]) {
                    reversals[5] = true;
                    if (n + 1 > complete[1]) {
                        complete[1] = n + 1;
                    }
                }
                ++n;
            }
            if (reversals[0] && (reversals[1] || reversals[2]) || reversals[1] && (reversals[0] || reversals[2]) || reversals[2] && (reversals[0] || reversals[1])) {
                this._reversals[0] = reversals[0];
                this._reversals[1] = reversals[1];
                this._reversals[2] = reversals[2];
                this.sentiment = Sentiment.BULLISH;
                return;
            }
            if (reversals[3] && (reversals[4] || reversals[5]) || reversals[4] && (reversals[3] || reversals[5]) || reversals[5] && (reversals[3] || reversals[4])) {
                this._reversals[0] = reversals[3];
                this._reversals[1] = reversals[4];
                this._reversals[2] = reversals[5];
                this.sentiment = Sentiment.BEARISH;
                return;
            }
            this._reversals[2] = false;
            this._reversals[1] = false;
            this._reversals[0] = false;
        }
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }
}

