/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class Volume
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getNumberFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            return this.formatter.format(this.getValue(item));
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private long getValue(WatchlistItem item) {
        if (item.getSecurity() == null) {
            return 0L;
        }
        Quote quote = item.getSecurity().getQuote();
        if (quote != null) {
            return quote.getVolume();
        }
        return 0L;
    }
}

