/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class TodayGainLoss
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            double value = this.getValue(item);
            if (value > 0.0) {
                return "+" + this.formatter.format(this.getValue(item));
            }
            return this.formatter.format(this.getValue(item));
        }
        if (element instanceof Watchlist) {
            double totalGain = 0.0;
            for (WatchlistItem item : ((Watchlist)element).getItems()) {
                if (item.getSecurity() == null) continue;
                totalGain += this.getValue(item);
            }
            if (totalGain > 0.0) {
                return "+" + this.formatter.format(totalGain);
            }
            return this.formatter.format(totalGain);
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(WatchlistItem item) {
        double gain = 0.0;
        if (item.getSecurity() == null) {
            return 0.0;
        }
        if (item.getPosition() != null && item.getSecurity().getChange() != 0.0) {
            gain = item.getParent().isUseDefaultCurrency() ? (double)item.getPosition().intValue() * item.getSecurity().getChange() : CurrencyConverter.getInstance().convert(gain, item.getSecurity().getCurrency(), item.getParent().getCurrency());
        }
        return gain;
    }
}

