/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.IEditableLabelProvider;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class PurchasePrice
extends LabelProvider
implements IEditableLabelProvider,
Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            return this.formatter.format(this.getValue(item));
        }
        if (element instanceof Watchlist) {
            double total = 0.0;
            for (WatchlistItem item : ((Watchlist)element).getItems()) {
                if (item == null) continue;
                total += this.getValue(item);
            }
            return this.formatter.format(total);
        }
        return "";
    }

    public String getEditableText(Object element) {
        return this.getText(element);
    }

    public boolean isEditable(Object element) {
        return element instanceof WatchlistItem;
    }

    public void setEditableText(Object element, String text) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            try {
                item.setPurchasePrice(this.formatter.parse(text));
                item.notifyObservers();
            }
            catch (ParseException e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(WatchlistItem item) {
        if (item != null && item.getPurchasePrice() != null) {
            if (item.getParent().isUseDefaultCurrency()) {
                return item.getPurchasePrice();
            }
            return CurrencyConverter.getInstance().convert(item.getPurchasePrice(), item.getSecurity().getCurrency(), item.getParent().getCurrency());
        }
        return 0.0;
    }
}

