/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Level2Ask;
import pk.com.softech.tradingterminal.core.db.Level2Bid;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class Pressure
extends LabelProvider
implements Comparator {
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_HALF_WIDTH = 50;
    NumberFormat formatter = CorePlugin.getNumberFormatter();
    private Color bidColor = Display.getDefault().getSystemColor(3);
    private Color bidFillColor = new Color((Device)Display.getDefault(), this.blend(this.bidColor.getRGB(), new RGB(0, 0, 0), 75));
    private Color askColor = Display.getDefault().getSystemColor(5);
    private Color askFillColor = new Color((Device)Display.getDefault(), this.blend(this.askColor.getRGB(), new RGB(0, 0, 0), 75));
    private Color backgroundColor = Display.getDefault().getSystemColor(1);
    Double bidPressure = 0.0;
    Double askPressure = 0.0;

    public String getText(Object element) {
        boolean cfr_ignored_0 = element instanceof WatchlistItem;
        return "";
    }

    public int compare(Object o1, Object o2) {
        return this.bidPressure.compareTo(this.askPressure);
    }

    public Image getImage(Object element) {
        WatchlistItem item;
        if (element instanceof WatchlistItem && (item = (WatchlistItem)element).getSecurity() != null) {
            Image image = new Image((Device)Display.getDefault(), 100, 16);
            this.buildValue(item.getSecurity(), image);
            return image;
        }
        return null;
    }

    protected void buildValue(Security security, Image image) {
        Level2Ask ask;
        Level2Bid bid = (Level2Bid)security.getLevel2BidMBO();
        if (bid != null) {
            int i = 0;
            while (i < bid.size()) {
                this.bidPressure = this.bidPressure + (double)bid.get((int)i).quantity;
                ++i;
            }
        }
        if ((ask = (Level2Ask)security.getLevel2AskMBO()) != null) {
            int i = 0;
            while (i < ask.size()) {
                this.askPressure = this.askPressure + (double)ask.get((int)i).quantity;
                ++i;
            }
        }
        int bidPixels = (int)(this.bidPressure / (this.bidPressure + this.askPressure) * 50.0);
        int askPixels = (int)(this.askPressure / (this.bidPressure + this.askPressure) * 50.0);
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(this.backgroundColor);
            gc.fillRectangle(0, 0, 100, 16);
            gc.setBackground(this.bidFillColor);
            gc.fillRectangle(50 - bidPixels, 0, bidPixels, 16);
            gc.setBackground(this.askFillColor);
            gc.fillRectangle(50, 0, askPixels, 16);
            gc.setLineWidth(2);
            gc.setForeground(this.bidColor);
            gc.drawLine(50 - bidPixels - 1, 1, 50, 1);
            gc.drawLine(50 - bidPixels - 1, 0, 50 - bidPixels, 15);
            gc.drawLine(50 - bidPixels - 1, 15, 50, 15);
            gc.setForeground(this.askColor);
            gc.drawLine(50, 1, 50 + askPixels, 1);
            gc.drawLine(50 + askPixels - 1, 0, 50 + askPixels - 1, 15);
            gc.drawLine(50, 15, 50 + askPixels, 15);
        }
        finally {
            gc.dispose();
        }
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }
}

