/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;

public class HighPrice
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            return this.formatter.format(this.getValue(item));
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(WatchlistItem item) {
        if (item.getSecurity() == null) {
            return 0.0;
        }
        if (item.getSecurity().getHigh() != null) {
            if (item.getParent().isUseDefaultCurrency()) {
                return item.getSecurity().getHigh();
            }
            return CurrencyConverter.getInstance().convert(item.getSecurity().getHigh(), item.getSecurity().getCurrency(), item.getParent().getCurrency());
        }
        return 0.0;
    }
}

