/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class HighPercent
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            double value = this.getValue(item);
            double valuePerc = this.getValuePerc(item);
            if (value > 0.0) {
                return "+" + this.formatter.format(value) + " (+" + this.formatter.format(valuePerc) + " %)";
            }
            return String.valueOf(this.formatter.format(value)) + " (" + this.formatter.format(valuePerc) + " %)";
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(WatchlistItem item) {
        double highP = 0.0;
        if (item.getSecurity() == null) {
            return 0.0;
        }
        Quote quote = item.getSecurity().getQuote();
        if (quote != null && quote.getLast() != 0.0 && item.getSecurity().getHigh() != null) {
            highP = item.getParent().isUseDefaultCurrency() ? item.getSecurity().getHigh() - quote.getLast() : CurrencyConverter.getInstance().convert(highP, item.getSecurity().getCurrency(), item.getParent().getCurrency());
        }
        return highP;
    }

    private double getValuePerc(WatchlistItem item) {
        double highP = 0.0;
        if (item.getSecurity() == null) {
            return 0.0;
        }
        Quote quote = item.getSecurity().getQuote();
        if (quote != null && quote.getLast() != 0.0 && item.getSecurity().getHigh() != null) {
            highP = item.getParent().isUseDefaultCurrency() ? (item.getSecurity().getHigh() != 0.0 ? (item.getSecurity().getHigh() - quote.getLast()) / item.getSecurity().getHigh() * 100.0 : 0.0) : (item.getSecurity().getLow() != 0.0 ? CurrencyConverter.getInstance().convert(highP, item.getSecurity().getCurrency(), item.getParent().getCurrency()) : 0.0);
        }
        return highP;
    }
}

