/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.watchlist;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class BookValue
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof WatchlistItem) {
            WatchlistItem item = (WatchlistItem)element;
            return this.formatter.format(this.getValue(item));
        }
        if (element instanceof Watchlist) {
            double paid = 0.0;
            for (WatchlistItem item : ((Watchlist)element).getItems()) {
                if (item.getSecurity() == null) continue;
                paid += this.getValue(item);
            }
            return this.formatter.format(paid);
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((WatchlistItem)arg0) > this.getValue((WatchlistItem)arg1)) {
            return 1;
        }
        if (this.getValue((WatchlistItem)arg0) < this.getValue((WatchlistItem)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(WatchlistItem item) {
        double paid = 0.0;
        if (item.getSecurity() == null) {
            return 0.0;
        }
        Quote quote = item.getSecurity().getQuote();
        if (quote != null && item.getPosition() != null && item.getPurchasePrice() != null) {
            paid = (double)item.getPosition().intValue() * item.getPurchasePrice();
            if (!item.getParent().isUseDefaultCurrency()) {
                paid = CurrencyConverter.getInstance().convert((double)item.getPosition().intValue() * item.getPurchasePrice(), item.getSecurity().getCurrency(), item.getParent().getCurrency());
            }
        }
        return paid;
    }
}

