/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.trades;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Trade;

public class RemainingVolumeColumn
extends LabelProvider
implements Comparator {
    private NumberFormat numberFormat = CorePlugin.getNumberFormatter();

    public String getText(Object element) {
        if (element instanceof Trade) {
            Trade trade = (Trade)element;
            if (trade.getQuantity() - trade.getFilledQuantity() == 0) {
                return "0";
            }
            return this.numberFormat.format(trade.getQuantity() - trade.getFilledQuantity());
        }
        return "0";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((Trade)arg0) > this.getValue((Trade)arg1)) {
            return 1;
        }
        if (this.getValue((Trade)arg0) < this.getValue((Trade)arg1)) {
            return -1;
        }
        return 0;
    }

    private int getValue(Trade item) {
        if (item == null) {
            return 0;
        }
        if (item.getQuantity() - item.getFilledQuantity() != 0) {
            return item.getQuantity() - item.getFilledQuantity();
        }
        return 0;
    }
}

