/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.trades;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Trade;

public class AveragePriceColumn
extends LabelProvider
implements Comparator {
    private NumberFormat numberFormat = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof Trade) {
            Trade trade = (Trade)element;
            if (trade.getAveragePrice() == 0.0) {
                return "";
            }
            return this.numberFormat.format(trade.getAveragePrice());
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((Trade)arg0) > this.getValue((Trade)arg1)) {
            return 1;
        }
        if (this.getValue((Trade)arg0) < this.getValue((Trade)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(Trade item) {
        if (item == null) {
            return 0.0;
        }
        if (item.getAveragePrice() != 0.0) {
            return item.getAveragePrice();
        }
        return 0.0;
    }
}

