/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.orders;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Order;

public class StopPriceColumn
extends LabelProvider
implements Comparator {
    private NumberFormat numberFormat = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof Order) {
            Order order = (Order)element;
            if (order.getStopPrice() == 0.0f) {
                return "";
            }
            return this.numberFormat.format(order.getStopPrice());
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((Order)arg0) > this.getValue((Order)arg1)) {
            return 1;
        }
        if (this.getValue((Order)arg0) < this.getValue((Order)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(Order item) {
        if (item == null) {
            return 0.0;
        }
        if (item.getStopPrice() != 0.0f) {
            return item.getStopPrice();
        }
        return 0.0;
    }
}

