/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.orders;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Order;

public class AveragePriceColumn
extends LabelProvider
implements Comparator {
    private NumberFormat formatter = CorePlugin.getPriceFormatter();

    public String getText(Object element) {
        if (element instanceof Order) {
            Order order = (Order)element;
            if (order.getAveragePrice() == 0.0) {
                return "";
            }
            return this.formatter.format(order.getAveragePrice());
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((Order)arg0) > this.getValue((Order)arg1)) {
            return 1;
        }
        if (this.getValue((Order)arg0) < this.getValue((Order)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(Order item) {
        if (item == null) {
            return 0.0;
        }
        if (item.getAveragePrice() != 0.0) {
            return item.getAveragePrice();
        }
        return 0.0;
    }
}

