/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal.marketSummary;

import java.text.NumberFormat;
import java.util.Comparator;
import org.eclipse.jface.viewers.LabelProvider;
import pk.com.softech.messages.TopSymbolData;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class ChangePercColumn
extends LabelProvider
implements Comparator {
    private NumberFormat percentFormatter = CorePlugin.getPercentageFormatter();

    public String getText(Object element) {
        TopSymbolData data;
        if (element instanceof TopSymbolData && (data = (TopSymbolData)element) != null) {
            double percentage = this.getValue(data);
            if (percentage > 0.0) {
                return "+" + this.percentFormatter.format(percentage);
            }
            return String.valueOf(this.percentFormatter.format(percentage));
        }
        return "";
    }

    public int compare(Object arg0, Object arg1) {
        if (this.getValue((TopSymbolData)arg0) > this.getValue((TopSymbolData)arg1)) {
            return 1;
        }
        if (this.getValue((TopSymbolData)arg0) < this.getValue((TopSymbolData)arg1)) {
            return -1;
        }
        return 0;
    }

    private double getValue(TopSymbolData item) {
        if (item == null) {
            return 0.0;
        }
        if (item.getChangePercentage() != 0.0f) {
            return item.getChangePercentage() / 100.0f;
        }
        return 0.0;
    }
}

