/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.MarketResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.IEditableLabelProvider;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistColumn;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.transfers.WatchlistItemTransfer;
import pk.com.softech.tradingterminal.core.ui.NullSelection;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ExportToFileAction;
import pk.com.softech.tradingterminal.core.ui.actions.PropertiesAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.widgets.EditableTable;
import pk.com.softech.tradingterminal.core.ui.widgets.EditableTableColumn;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableItem;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.WatchlistColumnSelection;
import pk.com.softech.tradingterminal.trading.WatchlistItemSelection;
import pk.com.softech.tradingterminal.trading.actions.ToggleShowTotalsAction;
import pk.com.softech.tradingterminal.trading.dialogs.SectorPerformanceDialog;
import pk.com.softech.tradingterminal.trading.dialogs.TradeDialog;
import pk.com.softech.tradingterminal.trading.internal.AbstractLayout;
import pk.com.softech.tradingterminal.trading.internal.CellTicker;
import pk.com.softech.tradingterminal.trading.internal.watchlist.AskPrice;
import pk.com.softech.tradingterminal.trading.internal.watchlist.AskSize;
import pk.com.softech.tradingterminal.trading.internal.watchlist.BidPrice;
import pk.com.softech.tradingterminal.trading.internal.watchlist.BidSize;
import pk.com.softech.tradingterminal.trading.internal.watchlist.Change;
import pk.com.softech.tradingterminal.trading.internal.watchlist.ChangePercent;
import pk.com.softech.tradingterminal.trading.internal.watchlist.ColumnRegistry;
import pk.com.softech.tradingterminal.trading.internal.watchlist.CurrentIndex;
import pk.com.softech.tradingterminal.trading.internal.watchlist.Exchange;
import pk.com.softech.tradingterminal.trading.internal.watchlist.HighPercent;
import pk.com.softech.tradingterminal.trading.internal.watchlist.LowPercent;
import pk.com.softech.tradingterminal.trading.internal.watchlist.Market;
import pk.com.softech.tradingterminal.trading.internal.watchlist.Position;
import pk.com.softech.tradingterminal.trading.internal.watchlist.PurchasePrice;
import pk.com.softech.tradingterminal.trading.internal.watchlist.Symbol;
import pk.com.softech.tradingterminal.trading.internal.watchlist.TodayGainLoss;
import pk.com.softech.tradingterminal.trading.internal.watchlist.TotalGainLoss;
import pk.com.softech.tradingterminal.trading.internal.watchlist.TotalTurnover;
import pk.com.softech.tradingterminal.trading.ui.dialogs.SaveAsDialog;
import pk.com.softech.tradingterminal.trading.views.QuoteRequestView;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;
import pk.com.softech.tradingterminal.trading.wizards.WatchlistItemPropertiesDialog;

public class WatchlistTableViewer
extends AbstractLayout
implements ICollectionObserver {
    public static final String EVEN_ROWS_BACKGROUND = "TABLE_EVEN_ROWS_BACKGROUND";
    public static final String EVEN_ROWS_FOREGROUND = "TABLE_EVEN_ROWS_FOREGROUND";
    public static final String ODD_ROWS_BACKGROUND = "TABLE_ODD_ROWS_BACKGROUND";
    public static final String ODD_ROWS_FOREGROUND = "TABLE_ODD_ROWS_FOREGROUND";
    public static final String TOTALS_ROWS_BACKGROUND = "TABLE_TOTALS_ROWS_BACKGROUND";
    public static final String TOTALS_ROWS_FOREGROUND = "TABLE_TOTALS_ROWS_FOREGROUND";
    public static final String POSITIVE_TICK_BACKGROUND = "TABLE_POSITIVE_TICK_BACKGROUND";
    public static final String NEGATIVE_TICK_BACKGROUND = "TABLE_NEGATIVE_TICK_BACKGROUND";
    public static final String POSITIVE_FOREGROUND = "TABLE_POSITIVE_FOREGROUND";
    public static final String NEGATIVE_FOREGROUND = "TABLE_NEGATIVE_FOREGROUND";
    public static final String COLUMN_BID_COLOR = "COLUMN_BID_COLOR";
    public static final String COLUMN_ASK_COLOR = "COLUMN_ASK_COLOR";
    public static final String ALERT_BACKGROUND = "TABLE_ALERT_BACKGROUND";
    public static final String TABLE_WATCH_FONT = "TABLE_WATCH_FONT";
    public static final String TABLE_WATCH_BG = "TABLE_WATCH_BG";
    public static final String PREFS_HIDE_SCRIP = "HIDE_SCRIP";
    List list = new ArrayList();
    Composite parent;
    Composite content;
    Composite composite;
    Composite sectorComposite;
    EditableTable table;
    Color evenForeground;
    Color evenBackground;
    Color oddForeground;
    Color oddBackground;
    Color totalsForeground;
    Color totalsBackground;
    Color tickPositiveBackground;
    Color tickNegativeBackground;
    Color negativeForeground;
    Color positiveForeground;
    Color columnBidForeground;
    Color columnAskForeground;
    Color alertHilightBackground;
    Font tableFont;
    Color tableBG;
    boolean showTotals = false;
    boolean singleClick = true;
    int sortColumn = -1;
    int sortDirection = 0;
    Action toggleShowTotals;
    Action autoResizeAction;
    Action exportAction;
    Action saveAsAction;
    Action propertiesAction;
    Action hideSymbolScrip;
    IMenuManager menuManager;
    IPreferenceStore preferences;
    private String viewType = "";
    WatchlistColumn selectedColumn;
    Combo sectorsCombo;
    Shell tip = null;
    Label label = null;
    Text textSearch;
    Label symbolLabel;
    Label sectorLink;
    public boolean showSectors = false;
    public boolean doSorting = true;
    Font font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
    Font font_underline = WidgetFactory.font_registry.get("FONT_9_UNDERLINE");
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                WatchlistTableViewer.this.setTheme((ITheme)event.getNewValue());
            } else {
                IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
                ITheme theme = themeManager.getCurrentTheme();
                if (event.getProperty().equals(WatchlistTableViewer.EVEN_ROWS_BACKGROUND)) {
                    WatchlistTableViewer.this.evenBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.EVEN_ROWS_FOREGROUND)) {
                    WatchlistTableViewer.this.evenForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.ODD_ROWS_BACKGROUND)) {
                    WatchlistTableViewer.this.oddBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.ODD_ROWS_FOREGROUND)) {
                    WatchlistTableViewer.this.oddForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.TOTALS_ROWS_FOREGROUND)) {
                    WatchlistTableViewer.this.totalsForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.TOTALS_ROWS_BACKGROUND)) {
                    WatchlistTableViewer.this.totalsBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.POSITIVE_FOREGROUND)) {
                    WatchlistTableViewer.this.positiveForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.NEGATIVE_FOREGROUND)) {
                    WatchlistTableViewer.this.negativeForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.POSITIVE_TICK_BACKGROUND)) {
                    WatchlistTableViewer.this.tickPositiveBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.NEGATIVE_TICK_BACKGROUND)) {
                    WatchlistTableViewer.this.tickNegativeBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.COLUMN_ASK_COLOR)) {
                    WatchlistTableViewer.this.columnAskForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.COLUMN_BID_COLOR)) {
                    WatchlistTableViewer.this.columnBidForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.ALERT_BACKGROUND)) {
                    WatchlistTableViewer.this.alertHilightBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.TABLE_WATCH_FONT)) {
                    WatchlistTableViewer.this.tableFont = theme.getFontRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistTableViewer.TABLE_WATCH_BG)) {
                    WatchlistTableViewer.this.tableBG = theme.getColorRegistry().get(event.getProperty());
                }
            }
            WatchlistTableViewer.this.updateView(false);
        }
    };
    Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Object provider = WatchlistTableViewer.this.table.getColumn(WatchlistTableViewer.this.sortColumn).getData("labelProvider");
            if (provider instanceof Comparator) {
                if (WatchlistTableViewer.this.sortDirection == 0) {
                    return ((Comparator)provider).compare(arg0, arg1);
                }
                return ((Comparator)provider).compare(arg1, arg0);
            }
            return 0;
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            WatchlistColumn column = (WatchlistColumn)tableColumn.getData();
            int index = WatchlistTableViewer.this.table.indexOf(tableColumn);
            if (index == WatchlistTableViewer.this.sortColumn) {
                if (WatchlistTableViewer.this.sortDirection == 1) {
                    WatchlistTableViewer.this.sortColumn = -1;
                } else {
                    WatchlistTableViewer.this.sortDirection = 1;
                }
            } else {
                WatchlistTableViewer.this.sortColumn = index;
                WatchlistTableViewer.this.sortDirection = 0;
            }
            if (WatchlistTableViewer.this.sortColumn != -1) {
                String s = String.valueOf(column.getId()) + ";" + String.valueOf(WatchlistTableViewer.this.sortDirection);
                WatchlistTableViewer.this.getView().getPreferenceStore().setValue("SORT", s);
            } else {
                WatchlistTableViewer.this.getView().getPreferenceStore().setValue("SORT", "");
            }
            WatchlistTableViewer.this.doSorting = false;
            WatchlistTableViewer.this.updateView(false);
        }
    };
    ControlAdapter columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            WatchlistColumn column = (WatchlistColumn)tableColumn.getData();
            WatchlistTableViewer.this.getView().getPreferenceStore().setValue(String.valueOf(column.getId()) + ".width", tableColumn.getWidth());
        }

        public void controlMoved(ControlEvent e) {
        }
    };

    public WatchlistTableViewer(WatchlistView view) {
        super(view);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().addCollectionObserver((ICollectionObserver)this);
        this.viewType = this.getViewSite().getSecondaryId();
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
        this.preferences.setDefault(String.valueOf(this.viewType) + PREFS_HIDE_SCRIP, false);
    }

    @Override
    public Composite createPartControl(final Composite parent) {
        this.parent = parent;
        this.content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WatchlistTableViewer.this.table != null && !WatchlistTableViewer.this.table.isDisposed()) {
                    int[] ord = WatchlistTableViewer.this.table.getColumnOrder();
                    ArrayList<WatchlistColumn> lst = new ArrayList<WatchlistColumn>();
                    int i = 1;
                    while (i < WatchlistTableViewer.this.table.getColumnCount()) {
                        TableColumn tc = WatchlistTableViewer.this.table.getColumn(ord[i]);
                        WatchlistColumn wc = (WatchlistColumn)tc.getData();
                        lst.add(wc);
                        ++i;
                    }
                    WatchlistTableViewer.this.getView().getWatchlist().setColumns(lst);
                    CorePlugin.getRepository().save((PersistentObject)WatchlistTableViewer.this.getView().getWatchlist());
                }
            }
        });
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
        this.composite = new Composite(this.content, 0);
        GridLayout layout = new GridLayout(5, false);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        new GridData(100, 18);
        new GridData(26, 18);
        GridData descGridData = new GridData(400, 18);
        Image img = TradingPlugin.getImageDescriptor("icons/eview16/Search.png").createImage();
        Label scrip = new Label(this.composite, 0);
        scrip.setText("Scrip  ");
        Label imageSearch = new Label(this.composite, 0);
        imageSearch.setImage(img);
        this.textSearch = new Text(this.composite, 2048);
        this.textSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.textSearch.setMessage("Search Security...");
        this.textSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.character == '\r') {
                    Security security = CorePlugin.getRepository().getSecurity(WatchlistTableViewer.this.textSearch.getText().toUpperCase());
                    if (security != null) {
                        Watchlist watchlist = WatchlistTableViewer.this.getView().getWatchlist();
                        if (watchlist != null) {
                            if (!watchlist.isExists(security)) {
                                WatchlistItem item = new WatchlistItem();
                                item.setParent(watchlist);
                                item.setSecurity(security);
                                watchlist.getItems().add((Object)item);
                            } else {
                                int i = 0;
                                while (i < WatchlistTableViewer.this.table.getItemCount() - 1) {
                                    WatchlistTableItem item = (WatchlistTableItem)WatchlistTableViewer.this.table.getItem(i);
                                    if (item.getWatchlistItem().getSecurity().equals((Object)security)) {
                                        WatchlistTableViewer.this.table.setSelection((TableItem)item);
                                        WatchlistTableViewer.this.updateSelection();
                                    }
                                    ++i;
                                }
                            }
                            WatchlistTableViewer.this.symbolLabel.setText(String.valueOf(security.getDescription()) + " - " + security.getSector() + " Sector");
                            WatchlistTableViewer.this.textSearch.setText("");
                        }
                    } else {
                        WatchlistTableViewer.this.textSearch.setText("");
                        WatchlistTableViewer.this.symbolLabel.setText("");
                    }
                }
            }
        });
        new Label(this.composite, 0);
        this.symbolLabel = new Label(this.composite, 0);
        this.symbolLabel.setLayoutData((Object)descGridData);
        this.symbolLabel.setFont(this.font_bold);
        this.symbolLabel.setText("");
        this.sectorComposite = new Composite(this.content, 0);
        GridLayout lay = new GridLayout(4, false);
        this.sectorComposite.setLayout((Layout)lay);
        this.sectorComposite.setLayoutData((Object)new GridData(16384, 16384, true, false));
        GridData comboGridData = new GridData(130, 20);
        GridData labelGridData = new GridData(33, 20);
        GridData linkGridData = new GridData(150, 20);
        Image sectorImage = TradingPlugin.getImageDescriptor("icons/eview16/Sector-Performance.png").createImage();
        Label secImg = new Label(this.sectorComposite, 0);
        secImg.setImage(sectorImage);
        secImg.setSize(10, 18);
        secImg.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SectorPerformanceDialog dlg = new SectorPerformanceDialog(null, null, 2);
                dlg.open();
            }
        });
        this.sectorLink = new Label(this.sectorComposite, 0);
        this.sectorLink.setText("Sector Performance");
        this.sectorLink.setFont(this.font_bold);
        this.sectorLink.setForeground(Display.getCurrent().getSystemColor(6));
        this.sectorLink.setLayoutData((Object)linkGridData);
        this.sectorLink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                SectorPerformanceDialog dlg = new SectorPerformanceDialog(null, null, 2);
                dlg.open();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.sectorLink.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                WatchlistTableViewer.this.sectorLink.setFont(WatchlistTableViewer.this.font_underline);
                WatchlistTableViewer.this.sectorLink.setForeground(Display.getCurrent().getSystemColor(9));
            }

            public void mouseExit(MouseEvent e) {
                WatchlistTableViewer.this.sectorLink.setFont(WatchlistTableViewer.this.font_bold);
                WatchlistTableViewer.this.sectorLink.setForeground(Display.getCurrent().getSystemColor(6));
            }

            public void mouseEnter(MouseEvent e) {
                WatchlistTableViewer.this.sectorLink.setFont(WatchlistTableViewer.this.font_underline);
                WatchlistTableViewer.this.sectorLink.setForeground(Display.getCurrent().getSystemColor(9));
            }
        });
        Label secLabel = new Label(this.sectorComposite, 0);
        secLabel.setText("Sector");
        secLabel.setLayoutData((Object)labelGridData);
        this.sectorsCombo = new Combo(this.sectorComposite, 8);
        this.sectorsCombo.setLayoutData((Object)comboGridData);
        this.sectorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Watchlist watchlist = (Watchlist)CorePlugin.getRepository().load(Watchlist.class, WatchlistTableViewer.this.sectorsCombo.getText());
                WatchlistTableViewer.this.getView().setWatchlist(watchlist);
            }
        });
        this.table = new EditableTable(this.content, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setBackground(parent.getBackground());
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WatchlistTableViewer.this.singleClick) {
                    WatchlistTableViewer.this.updateSelection();
                }
            }
        });
        final Shell shell = parent.getShell();
        final Display d = parent.getDisplay();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                try {
                    if (WatchlistTableViewer.this.singleClick) {
                        WatchlistTableViewer.this.selectedColumn = WatchlistTableViewer.this.getColumn(e);
                        if (WatchlistTableViewer.this.table.getItem(new Point(e.x, e.y)) == null) {
                            WatchlistTableViewer.this.table.deselectAll();
                            WatchlistTableViewer.this.updateSelection();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                WatchlistTableViewer.this.selectedColumn = WatchlistTableViewer.this.getColumn(e);
                if (WatchlistTableViewer.this.table.getItem(new Point(e.x, e.y)) == null) {
                    WatchlistTableViewer.this.table.deselectAll();
                    WatchlistTableViewer.this.updateSelection();
                } else if (WatchlistTableViewer.this.selectedColumn != null && (WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.AskPrice") || WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.AskSize"))) {
                    Security security = null;
                    try {
                        WatchlistItem[] watchItem = WatchlistTableViewer.this.getSelection();
                        if (watchItem != null && watchItem.length > 0 && (security = watchItem[0].getSecurity()) != null && Resources.loginStatus) {
                            TradeDialog dlg = new TradeDialog(null);
                            dlg.open(security, "buy");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (WatchlistTableViewer.this.selectedColumn != null && (WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.BidPrice") || WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.BidSize"))) {
                    Security security = null;
                    try {
                        WatchlistItem[] watchItem = WatchlistTableViewer.this.getSelection();
                        if (watchItem != null && watchItem.length > 0 && (security = watchItem[0].getSecurity()) != null && Resources.loginStatus) {
                            TradeDialog dlg = new TradeDialog(null);
                            dlg.open(security, "sell");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (WatchlistTableViewer.this.selectedColumn != null && WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.symbol")) {
                    Security security = null;
                    try {
                        WatchlistItem[] watchItem = WatchlistTableViewer.this.getSelection();
                        if (watchItem != null && watchItem.length > 0) {
                            security = watchItem[0].getSecurity();
                        }
                        if (Resources.PRODUCT_NAME != ProductNames.IMTRADE && Resources.PRODUCT_NAME != ProductNames.ZAFFAR) {
                            QuoteRequestView view = (QuoteRequestView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.quoteRequest");
                            if (security != null) {
                                view.setSecurity(security);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setBackground(((TableItem)event.item).getBackground());
                event.gc.fillRectangle(event.getBounds());
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                try {
                    if (WatchlistTableViewer.this.tip != null) {
                        WatchlistTableViewer.this.tip.dispose();
                        WatchlistTableViewer.this.tip = null;
                        WatchlistTableViewer.this.label = null;
                    }
                    WatchlistTableViewer.this.selectedColumn = WatchlistTableViewer.this.getColumn(e);
                    if (WatchlistTableViewer.this.table.getItem(new Point(e.x, e.y)) == null) {
                        WatchlistTableViewer.this.table.deselectAll();
                        WatchlistTableViewer.this.updateSelection();
                    } else if (WatchlistTableViewer.this.selectedColumn != null && WatchlistTableViewer.this.selectedColumn.toString().equalsIgnoreCase("watchlist.symbol")) {
                        Listener labelListener = new Listener(){

                            public void handleEvent(Event event) {
                                Label label = (Label)event.widget;
                                Shell shell = label.getShell();
                                switch (event.type) {
                                    case 5: {
                                        Event e = new Event();
                                        e.item = (TableItem)label.getData("_TABLEITEM");
                                        if (!(this).WatchlistTableViewer.this.table.isDisposed() && (this).WatchlistTableViewer.this.table.isEnabled()) {
                                            (this).WatchlistTableViewer.this.table.setSelection(new TableItem[]{(TableItem)e.item});
                                            (this).WatchlistTableViewer.this.table.notifyListeners(13, e);
                                        }
                                        shell.dispose();
                                        break;
                                    }
                                    case 3: 
                                    case 7: {
                                        shell.dispose();
                                    }
                                }
                            }
                        };
                        TableItem item = WatchlistTableViewer.this.table.getItem(new Point(e.x, e.y));
                        if (item != null) {
                            if (WatchlistTableViewer.this.tip != null && !WatchlistTableViewer.this.tip.isDisposed()) {
                                WatchlistTableViewer.this.tip.dispose();
                            }
                            WatchlistTableViewer.this.tip = new Shell(shell, 540676);
                            WatchlistTableViewer.this.tip.setBackground(d.getSystemColor(29));
                            FillLayout layout = new FillLayout();
                            layout.marginWidth = 2;
                            WatchlistTableViewer.this.tip.setLayout((Layout)layout);
                            WatchlistTableViewer.this.label = new Label((Composite)WatchlistTableViewer.this.tip, 0);
                            WatchlistTableViewer.this.label.setForeground(d.getSystemColor(28));
                            WatchlistTableViewer.this.label.setBackground(d.getSystemColor(29));
                            WatchlistTableViewer.this.label.setData("_TABLEITEM", (Object)item);
                            if (item instanceof WatchlistTableItem) {
                                WatchlistTableItem tableItem = (WatchlistTableItem)item;
                                Security s = tableItem.getWatchlistItem().getSecurity();
                                WatchlistTableViewer.this.label.setText(s.getDescription());
                                WatchlistTableViewer.this.label.setLocation(new Point(e.x, e.y));
                                WatchlistTableViewer.this.label.addListener(7, labelListener);
                                WatchlistTableViewer.this.label.addListener(3, labelListener);
                                Point size = WatchlistTableViewer.this.tip.computeSize(-1, -1);
                                Rectangle rect = item.getBounds(0);
                                Point pt = WatchlistTableViewer.this.table.toDisplay(rect.x, rect.y);
                                WatchlistTableViewer.this.tip.setBounds(pt.x + 15, pt.y + 15, size.x, size.y);
                                WatchlistTableViewer.this.tip.setVisible(true);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        Listener tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 7: 
                    case 37: {
                        if (WatchlistTableViewer.this.tip == null) break;
                        WatchlistTableViewer.this.tip.dispose();
                        WatchlistTableViewer.this.tip = null;
                        WatchlistTableViewer.this.label = null;
                    }
                }
            }
        };
        this.table.addListener(7, tableListener);
        this.table.addListener(37, tableListener);
        TableColumn column = new TableColumn((Table)this.table, 0);
        column.setWidth(0);
        column.setResizable(false);
        DragSource dragSource = new DragSource((Control)this.table, 3);
        dragSource.setTransfer(new Transfer[]{SecurityTransfer.getInstance(), WatchlistItemTransfer.getInstance(), TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            WatchlistItem[] watchlistSelection;

            public void dragStart(DragSourceEvent event) {
                if (WatchlistTableViewer.this.table.getSelectionCount() == 0 || WatchlistTableViewer.this.table.getSelectionCount() == 1 && WatchlistTableViewer.this.getSelection().length == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TableItem[] tableItems = WatchlistTableViewer.this.table.getSelection();
                WatchlistItem[] selection = WatchlistTableViewer.this.getSelection();
                this.watchlistSelection = new WatchlistItem[selection.length];
                if (SecurityTransfer.getInstance().isSupportedType(event.dataType)) {
                    Security[] securities = new Security[selection.length];
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof WatchlistItem) {
                            securities[i] = selection[i].getSecurity();
                            this.watchlistSelection[i] = selection[i];
                        }
                        ++i;
                    }
                    event.data = securities;
                } else if (WatchlistItemTransfer.getInstance().isSupportedType(event.dataType)) {
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof WatchlistItem) {
                            this.watchlistSelection[i] = selection[i];
                        }
                        ++i;
                    }
                    event.data = this.watchlistSelection;
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    StringBuffer data = new StringBuffer();
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof WatchlistItem) {
                            WatchlistTableItem item = (WatchlistTableItem)tableItems[i];
                            int c = 1;
                            while (c < WatchlistTableViewer.this.table.getColumnCount()) {
                                if (c > 1) {
                                    data.append(";");
                                }
                                data.append(item.getText(c));
                                ++c;
                            }
                            data.append("\r\n");
                            this.watchlistSelection[i] = item.getWatchlistItem();
                        }
                        ++i;
                    }
                    event.data = data.toString();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (!event.doit || event.detail == 2) {
                    // empty if block
                }
                this.watchlistSelection = null;
            }
        });
        this.showTotals = this.getView().getPreferenceStore().getBoolean("SHOW_TOTALS");
        this.toggleShowTotals = new ToggleShowTotalsAction(this);
        this.toggleShowTotals.setChecked(this.showTotals);
        this.saveAsAction = new Action("Save As"){

            public void run() {
                ArrayList<WatchlistItem> list = new ArrayList<WatchlistItem>();
                new ArrayList();
                int i = 0;
                while (i < WatchlistTableViewer.this.table.getItemCount()) {
                    if (WatchlistTableViewer.this.table.getItem(i) instanceof WatchlistTableItem) {
                        WatchlistTableItem tableItem = (WatchlistTableItem)WatchlistTableViewer.this.table.getItem(i);
                        WatchlistItem old = tableItem.getWatchlistItem();
                        WatchlistItem item = new WatchlistItem();
                        item.setData(old.getData());
                        item.setId(old.getId());
                        if (old.getPurchasePrice() != null) {
                            item.setPurchasePrice((Number)old.getPurchasePrice());
                        }
                        item.setSecurity(old.getSecurity());
                        item.setPosition(old.getPosition());
                        item.setRepository(old.getRepository());
                        list.add(item);
                    }
                    ++i;
                }
                SaveAsDialog saveAs = new SaveAsDialog(parent.getShell(), list, WatchlistTableViewer.this.getView().getWatchlist().getColumns());
                saveAs.open();
            }
        };
        this.hideSymbolScrip = new Action("Hide Scrip", 2){

            public void run() {
                WatchlistTableViewer.this.composite.setVisible(!this.isChecked());
                ((GridData)WatchlistTableViewer.this.composite.getLayoutData()).exclude = this.isChecked();
                WatchlistTableViewer.this.content.layout();
            }
        };
        this.hideSymbolScrip.setChecked(this.preferences.getBoolean(String.valueOf(this.viewType) + PREFS_HIDE_SCRIP));
        this.menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.menuManager.appendToGroup("toggles", (IAction)this.toggleShowTotals);
        this.autoResizeAction = new ResizeColumnsAction((Table)this.table);
        this.menuManager.appendToGroup("layout", (IAction)this.autoResizeAction);
        this.exportAction = new ExportToFileAction((Table)this.table, this.getView().getTitle());
        this.menuManager.appendToGroup("layout", (IAction)this.exportAction);
        this.menuManager.appendToGroup("layout", (IAction)this.saveAsAction);
        this.propertiesAction = new PropertiesAction(){

            public void run() {
                TableItem[] selection = WatchlistTableViewer.this.table.getSelection();
                if (selection.length != 0 && selection[0] instanceof WatchlistTableItem) {
                    WatchlistItem item = ((WatchlistTableItem)selection[0]).getWatchlistItem();
                    WatchlistItemPropertiesDialog dlg = new WatchlistItemPropertiesDialog(item, WatchlistTableViewer.this.getViewSite().getShell());
                    dlg.open();
                }
            }
        };
        this.propertiesAction.setEnabled(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("properties", (IAction)this.propertiesAction);
        actionBars.updateActionBars();
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                WatchlistTableViewer.this.getView().fillMenuBars(menuManager);
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IContributionItem)new Separator("group0"));
                menuManager.add((IContributionItem)new Separator("group1"));
                menuManager.add((IContributionItem)new Separator("group2"));
                menuManager.add((IContributionItem)new Separator("group3"));
                menuManager.add((IContributionItem)new Separator("group4"));
                menuManager.add((IContributionItem)new Separator("group5"));
                menuManager.add((IContributionItem)new Separator("news"));
                menuManager.add((IAction)WatchlistTableViewer.this.saveAsAction);
                menuManager.add((IAction)WatchlistTableViewer.this.exportAction);
                menuManager.add((IContributionItem)new Separator("search"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("bottom"));
                menuManager.add((IAction)WatchlistTableViewer.this.propertiesAction);
            }
        });
        this.table.setMenu(menuMgr.createContextMenu((Control)this.table));
        this.getView().getSite().registerContextMenu(menuMgr, this.getView().getSite().getSelectionProvider());
        this.composite.setVisible(false);
        ((GridData)this.composite.getLayoutData()).exclude = true;
        this.sectorComposite.setVisible(false);
        ((GridData)this.sectorComposite.getLayoutData()).exclude = true;
        this.content.layout();
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Resources.loginStatus && WatchlistTableViewer.this.getView().getWatchlist().getWatchlistType() == 1) {
                    WatchlistTableViewer.this.populateSectorWatch();
                }
                if (Resources.loginStatus && WatchlistTableViewer.this.getView().getWatchlist().getWatchlistType() == 0) {
                    WatchlistTableViewer.this.doSorting = true;
                    WatchlistTableViewer.this.updateView(false);
                    WatchlistTableViewer.this.composite.setVisible(!WatchlistTableViewer.this.hideSymbolScrip.isChecked());
                    ((GridData)WatchlistTableViewer.this.composite.getLayoutData()).exclude = WatchlistTableViewer.this.hideSymbolScrip.isChecked();
                    WatchlistTableViewer.this.content.layout();
                    WatchlistTableViewer.this.menuManager.appendToGroup("toggles", (IAction)WatchlistTableViewer.this.hideSymbolScrip);
                }
            }
        });
        return this.content;
    }

    @Override
    public void populateSectorWatch() {
        try {
            if (Resources.sectorKeys.contains(this.getView().getWatchlist().getId())) {
                this.sectorsCombo.removeAll();
                for (String item : Resources.sectorKeys) {
                    this.sectorsCombo.add(item);
                }
                this.showSectors = true;
            }
            if (this.showSectors) {
                this.sectorsCombo.setText(this.getView().getWatchlist().getId());
                this.sectorComposite.setVisible(true);
                ((GridData)this.sectorComposite.getLayoutData()).exclude = false;
                this.content.layout();
            }
        }
        catch (Exception exception) {}
    }

    protected void savePreferences() {
        this.preferences.setValue(String.valueOf(this.viewType) + PREFS_HIDE_SCRIP, this.hideSymbolScrip.isChecked());
    }

    protected void addSecurity(String exchange, String market, String symbol) {
        Security security = CorePlugin.getRepository().getSecurity(exchange, market, symbol);
        if (security != null) {
            Watchlist watchlist = this.getView().getWatchlist();
            if (watchlist != null) {
                if (!watchlist.isExists(security)) {
                    WatchlistItem item = new WatchlistItem();
                    item.setParent(watchlist);
                    item.setSecurity(security);
                    watchlist.getItems().add((Object)item);
                } else {
                    MessageDialog.openInformation(null, (String)this.getView().getTitle(), (String)"Symbol already exists");
                }
            }
        } else {
            MessageDialog.openError(null, (String)this.getView().getTitle(), (String)"Invalid symbol");
        }
    }

    void setFocus() {
        this.table.getParent().setFocus();
    }

    @Override
    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        theme.removePropertyChangeListener(this.themeChangeListener);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("properties", null);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.remove(this.toggleShowTotals.getId());
        menuManager.remove(this.autoResizeAction.getId());
        menuManager.remove(this.exportAction.getId());
        this.savePreferences();
        if (this.content != null) {
            this.content.dispose();
        }
    }

    @Override
    public void updateView(boolean ignoreSorting) {
        if (this.table != null && !this.table.isDisposed()) {
            int index = 1;
            String[] sorting = this.getView().getPreferenceStore().getString("SORT").split(";");
            if (sorting.length != 2) {
                sorting = new String[]{"", "0"};
            }
            this.sortDirection = new Integer(sorting[1]);
            for (WatchlistColumn column : this.getView().getWatchlist().getColumns()) {
                TableColumn tableColumn;
                String name = "";
                int style = 16384;
                Image image = null;
                ILabelProvider provider = ColumnRegistry.createLabelProvider(column.getId());
                if (provider != null) {
                    name = ColumnRegistry.getName(column.getId());
                    style = ColumnRegistry.getOrientation(column.getId());
                    if (provider instanceof ITableLabelProvider) {
                        name = ((ITableLabelProvider)provider).getColumnText((Object)this.getView().getWatchlist(), index);
                        image = ((ITableLabelProvider)provider).getColumnImage((Object)this.getView().getWatchlist(), index);
                    }
                } else {
                    LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + column.getId() + "]"));
                }
                if (index < this.table.getColumnCount()) {
                    tableColumn = this.table.getColumn(index);
                    tableColumn.setAlignment(style);
                    if (tableColumn.getData("labelProvider") != null) {
                        ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                    }
                } else {
                    tableColumn = new EditableTableColumn((Table)this.table, style);
                    tableColumn.addControlListener((ControlListener)this.columnControlListener);
                    tableColumn.addSelectionListener(this.columnSelectionListener);
                    tableColumn.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget.getData("labelProvider") != null) {
                                ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                            }
                        }
                    });
                }
                if (provider instanceof Exchange) {
                    ((EditableTableColumn)tableColumn).setEditorType(4);
                } else if (provider instanceof Market) {
                    if (Resources.systemClient == 1) {
                        name = "Mkt";
                    }
                    ((EditableTableColumn)tableColumn).setEditorType(3);
                } else if (provider instanceof Symbol) {
                    ((EditableTableColumn)tableColumn).setEditorType(0);
                } else if (provider instanceof PurchasePrice) {
                    ((EditableTableColumn)tableColumn).setEditorType(1);
                } else if (provider instanceof Position) {
                    ((EditableTableColumn)tableColumn).setEditorType(2);
                } else if (provider instanceof BidSize) {
                    name = "Buy Vol";
                } else if (provider instanceof BidPrice) {
                    name = "Buy Rate";
                } else if (provider instanceof AskSize) {
                    name = "Sell Vol";
                } else if (provider instanceof AskPrice) {
                    name = "Sell Rate";
                } else if (provider instanceof TotalTurnover) {
                    name = "Total Volume";
                    if (this.doSorting && this.getView().getWatchlist().getWatchlistType() == 1) {
                        this.sortColumn = index;
                    }
                }
                tableColumn.setText(name);
                tableColumn.setImage(image);
                tableColumn.setMoveable(true);
                tableColumn.setData((Object)column);
                tableColumn.setData("labelProvider", (Object)provider);
                if (column.getId().equals(sorting[0])) {
                    this.sortColumn = index;
                }
                ++index;
            }
            while (index < this.table.getColumnCount()) {
                this.table.getColumn(index).dispose();
            }
            this.list = new ArrayList(this.getView().getWatchlist().getItems());
            if (this.sortColumn >= 1 && this.sortColumn < this.table.getColumnCount() && !ignoreSorting) {
                this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                if (Resources.systemClient == 1 && this.doSorting) {
                    this.sortDirection = 0;
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                    this.sortDirection = 1;
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                } else {
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                }
            } else {
                this.table.setSortColumn(null);
                this.sortColumn = -1;
                this.sortDirection = 0;
            }
            this.updateTableContents();
            PreferenceStore preferences = this.getView().getPreferenceStore();
            int i = 1;
            while (i < this.table.getColumnCount()) {
                WatchlistColumn column = (WatchlistColumn)this.table.getColumn(i).getData();
                preferences.setDefault(String.valueOf(column.getId()) + ".width", -1);
                int size = preferences.getInt(String.valueOf(column.getId()) + ".width");
                if (size != -1) {
                    this.table.getColumn(i).setWidth(size);
                } else {
                    this.table.getColumn(i).pack();
                }
                ++i;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.table.getColumn(this.table.getColumnCount() - 1).pack();
            }
        }
    }

    public void updateTableContents() {
        int index = 0;
        for (WatchlistItem watchlistItem : this.list) {
            WatchlistTableItem tableItem;
            if (index < this.table.getItemCount()) {
                if (this.table.getItem(index) instanceof WatchlistTableItem) {
                    tableItem = (WatchlistTableItem)this.table.getItem(index);
                    tableItem.setWatchlistItem(watchlistItem);
                } else {
                    tableItem = new WatchlistTableItem((Table)this.table, 0, index, watchlistItem);
                }
            } else {
                tableItem = new WatchlistTableItem((Table)this.table, 0, index, watchlistItem);
            }
            tableItem.setBackground((index & 1) == 1 ? this.oddBackground : this.evenBackground);
            tableItem.setForeground((index & 1) == 1 ? this.oddForeground : this.evenForeground);
            ++index;
        }
        this.table.setFont(this.tableFont);
        this.table.setBackground(this.tableBG);
        if (this.showTotals) {
            WatchlistTotalsTableItem item = null;
            if (index < this.table.getItemCount() && this.table.getItem(index) instanceof WatchlistTotalsTableItem) {
                item = (WatchlistTotalsTableItem)this.table.getItem(index);
                System.out.println("get total : " + this.getView().getWatchlist().getTotals());
                item.setWatchlistItem(this.getView().getWatchlist().getTotals());
            }
            if (item == null) {
                item = new WatchlistTotalsTableItem((Table)this.table, 0, this.getView().getWatchlist().getTotals());
            }
            item.setBackground(this.totalsBackground);
            item.setForeground(this.totalsForeground);
            ++index;
        }
        this.table.setItemCount(index);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!WatchlistTableViewer.this.table.isDisposed()) {
                    WatchlistTableViewer.this.updateView(false);
                }
            }
        });
    }

    private void updateSelection() {
        boolean enable = false;
        if (this.table.getSelectionCount() != 0 && this.table.getSelection()[0] instanceof WatchlistTableItem) {
            WatchlistTableItem tableItem = (WatchlistTableItem)this.table.getSelection()[0];
            if (this.selectedColumn != null) {
                this.getView().getSite().getSelectionProvider().setSelection((ISelection)new WatchlistColumnSelection(tableItem.getWatchlistItem(), this.selectedColumn));
            } else {
                this.getView().getSite().getSelectionProvider().setSelection((ISelection)new WatchlistItemSelection(tableItem.getWatchlistItem()));
            }
            enable = true;
        } else {
            this.getView().getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
        }
        this.getView().fillMenuBars(null);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getGlobalActionHandler("cut").setEnabled(enable);
        actionBars.getGlobalActionHandler("copy").setEnabled(enable);
        actionBars.getGlobalActionHandler("delete").setEnabled(enable);
        actionBars.getGlobalActionHandler("properties").setEnabled(enable);
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof WatchlistItem) {
                        int index = WatchlistTableViewer.this.getView().getWatchlist().getItems().indexOf(o);
                        WatchlistTableViewer.this.list.add(index >= 0 ? index : WatchlistTableViewer.this.list.size(), o);
                        if (WatchlistTableViewer.this.sortColumn >= 0) {
                            Collections.sort(WatchlistTableViewer.this.list, WatchlistTableViewer.this.comparator);
                        }
                        WatchlistTableViewer.this.updateView(false);
                    } else if (o instanceof LoginConfirmation) {
                        if (Resources.exchangeNames != null) {
                            int a = 0;
                            while (a < CorePlugin.getRepository().allWatchlists().size()) {
                                Watchlist w = (Watchlist)CorePlugin.getRepository().allWatchlists().get(a);
                                w.setExchange((String)Resources.exchangeNames.get(0));
                                ++a;
                            }
                        }
                    } else if (o instanceof MarketResponse && Resources.marketTypes != null) {
                        try {
                            String market = MarketData.marketNames[MarketData.REGULAR];
                            int a = 0;
                            while (a < CorePlugin.getRepository().allWatchlists().size()) {
                                Watchlist w = (Watchlist)CorePlugin.getRepository().allWatchlists().get(a);
                                w.setMarket(market);
                                ++a;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(final Object o) {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TableItem[] items = WatchlistTableViewer.this.table.getItems();
                        int i = 0;
                        while (i < items.length) {
                            WatchlistTableItem tableItem;
                            if (items[i] instanceof WatchlistTableItem && (tableItem = (WatchlistTableItem)items[i]).getWatchlistItem().equals(o)) {
                                tableItem.dispose();
                                while (i < WatchlistTableViewer.this.table.getItemCount() - 1) {
                                    WatchlistTableViewer.this.table.getItem(i).setBackground((i & 1) == 1 ? WatchlistTableViewer.this.oddBackground : WatchlistTableViewer.this.evenBackground);
                                    ++i;
                                }
                                break;
                            }
                            ++i;
                        }
                        WatchlistTableViewer.this.list.remove(o);
                        if (WatchlistTableViewer.this.table.getSelectionCount() != 0) {
                            if (WatchlistTableViewer.this.table.getSelection()[0] instanceof WatchlistTableItem) {
                                WatchlistTableItem tableItem = (WatchlistTableItem)WatchlistTableViewer.this.table.getSelection()[0];
                                WatchlistTableViewer.this.getView().getSite().getSelectionProvider().setSelection((ISelection)new WatchlistItemSelection(tableItem.getWatchlistItem()));
                            }
                        } else {
                            WatchlistTableViewer.this.getView().getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
                        }
                    }
                    catch (Exception e) {
                        CorePlugin.logWarning((String)e.getMessage());
                    }
                }
            });
        }
    }

    public boolean isShowTotals() {
        return this.showTotals;
    }

    public void setShowTotals(boolean showTotals) {
        this.showTotals = showTotals;
        this.getView().getPreferenceStore().setValue("SHOW_TOTALS", showTotals);
    }

    @Override
    public WatchlistItem[] getSelection() {
        TableItem[] selection = this.table.getSelection();
        ArrayList<WatchlistItem> items = new ArrayList<WatchlistItem>();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] instanceof WatchlistTableItem) {
                WatchlistTableItem item = (WatchlistTableItem)selection[i];
                items.add(item.getWatchlistItem());
            }
            ++i;
        }
        return items.toArray(new WatchlistItem[0]);
    }

    @Override
    public void tickAlert(WatchlistItem watchlistItem, RGB foreground, RGB background) {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            WatchlistTableItem tableItem = (WatchlistTableItem)items[i];
            if (tableItem.getWatchlistItem().equals((Object)watchlistItem)) {
                Color fg = foreground != null ? new Color(null, foreground) : null;
                Color bg = background != null ? new Color(null, background) : new Color(null, this.alertHilightBackground.getRGB());
                tableItem.ticker.tick(bg, fg);
                if (bg != null) {
                    bg.dispose();
                }
                if (fg == null) break;
                fg.dispose();
                break;
            }
            ++i;
        }
    }

    @Override
    public int getItemIndex(Point point) {
        TableItem tableItem = this.table.getItem(this.table.toControl(point));
        return tableItem != null ? this.table.indexOf(tableItem) : -1;
    }

    protected void setTheme(ITheme theme) {
        this.positiveForeground = theme.getColorRegistry().get(POSITIVE_FOREGROUND);
        this.negativeForeground = theme.getColorRegistry().get(NEGATIVE_FOREGROUND);
        this.evenForeground = theme.getColorRegistry().get(EVEN_ROWS_FOREGROUND);
        this.evenBackground = theme.getColorRegistry().get(EVEN_ROWS_BACKGROUND);
        this.oddForeground = theme.getColorRegistry().get(ODD_ROWS_FOREGROUND);
        this.oddBackground = theme.getColorRegistry().get(ODD_ROWS_BACKGROUND);
        this.totalsForeground = theme.getColorRegistry().get(TOTALS_ROWS_FOREGROUND);
        this.totalsBackground = theme.getColorRegistry().get(TOTALS_ROWS_BACKGROUND);
        this.tickPositiveBackground = theme.getColorRegistry().get(POSITIVE_TICK_BACKGROUND);
        this.tickNegativeBackground = theme.getColorRegistry().get(NEGATIVE_TICK_BACKGROUND);
        this.columnAskForeground = theme.getColorRegistry().get(COLUMN_ASK_COLOR);
        this.columnBidForeground = theme.getColorRegistry().get(COLUMN_BID_COLOR);
        this.alertHilightBackground = theme.getColorRegistry().get(ALERT_BACKGROUND);
        this.tableFont = theme.getFontRegistry().get(TABLE_WATCH_FONT);
        this.tableBG = theme.getColorRegistry().get(TABLE_WATCH_BG);
        theme.addPropertyChangeListener(this.themeChangeListener);
    }

    public Table getTable() {
        return this.table;
    }

    protected WatchlistColumn getColumn(MouseEvent e) {
        Point p = new Point(e.x, e.y);
        TableItem item = this.table.getItem(p);
        if (item != null) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                TableColumn column;
                Rectangle rect = item.getBounds(i);
                if (rect.contains(p) && (column = this.table.getColumn(i)).getData() instanceof WatchlistColumn) {
                    return (WatchlistColumn)column.getData();
                }
                ++i;
            }
        }
        return null;
    }

    public class WatchlistTableItem
    extends TableItem
    implements DisposeListener,
    Observer,
    IEditableItem {
        private WatchlistItem watchlistItem;
        private CellTicker ticker;

        WatchlistTableItem(Table parent, int style, int index, WatchlistItem watchlistItem) {
            super(parent, style, index);
            this.addDisposeListener(this);
            this.ticker = new CellTicker(this, 3);
            this.setWatchlistItem(watchlistItem);
        }

        WatchlistTableItem(Table parent, int style, WatchlistItem watchlistItem) {
            super(parent, style);
            this.addDisposeListener(this);
            this.ticker = new CellTicker(this, 3);
            this.setWatchlistItem(watchlistItem);
        }

        protected void checkSubclass() {
        }

        void setWatchlistItem(WatchlistItem watchlistItem) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
            this.watchlistItem = watchlistItem;
            this.update(false);
            this.watchlistItem.addObserver((Observer)this);
        }

        WatchlistItem getWatchlistItem() {
            return this.watchlistItem;
        }

        synchronized void update(boolean tick) {
            TableColumn[] columns = this.getParent().getColumns();
            int i = 0;
            while (i < columns.length) {
                ILabelProvider provider = (ILabelProvider)columns[i].getData("labelProvider");
                if (provider != null) {
                    String oldValue = this.getText(i);
                    String newValue = provider.getText((Object)this.watchlistItem);
                    if (!tick || !newValue.equals(this.getText(i))) {
                        this.setText(i, newValue);
                        if (provider instanceof ChangePercent || provider instanceof Change || provider instanceof TotalGainLoss || provider instanceof TodayGainLoss || provider instanceof HighPercent || provider instanceof LowPercent) {
                            if (newValue.startsWith("+")) {
                                this.setForeground(i, WatchlistTableViewer.this.positiveForeground);
                            } else if (newValue.startsWith("-")) {
                                this.setForeground(i, WatchlistTableViewer.this.negativeForeground);
                            } else {
                                this.setForeground(i, null);
                            }
                        } else if (provider instanceof BidSize || provider instanceof BidPrice) {
                            this.setForeground(i, WatchlistTableViewer.this.columnBidForeground);
                        } else if (provider instanceof AskSize || provider instanceof AskPrice) {
                            this.setForeground(i, WatchlistTableViewer.this.columnAskForeground);
                        } else {
                            this.setForeground(i, null);
                        }
                        if (tick) {
                            if (provider instanceof IEditableLabelProvider) {
                                if (!((IEditableLabelProvider)provider).isEditable((Object)this.watchlistItem)) {
                                    this.ticker.tick(i);
                                }
                            } else if (!newValue.equals("") && (provider instanceof BidSize || provider instanceof BidPrice || provider instanceof AskSize || provider instanceof AskPrice || provider instanceof CurrentIndex || provider instanceof TotalGainLoss || provider instanceof TodayGainLoss)) {
                                if (oldValue.compareTo(newValue) < 0) {
                                    this.ticker.setBackground(WatchlistTableViewer.this.tickPositiveBackground);
                                } else if (oldValue.compareTo(newValue) > 0) {
                                    this.ticker.setBackground(WatchlistTableViewer.this.tickNegativeBackground);
                                }
                                this.ticker.tick(i);
                            }
                        }
                    }
                }
                ++i;
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!WatchlistTableItem.this.isDisposed()) {
                        WatchlistTableItem.this.update(true);
                    }
                }
            });
        }

        public boolean canEdit(int index) {
            ILabelProvider provider = (ILabelProvider)this.getParent().getColumn(index).getData("labelProvider");
            if (provider != null && provider instanceof IEditableLabelProvider) {
                return ((IEditableLabelProvider)provider).isEditable((Object)this.watchlistItem);
            }
            return false;
        }

        public boolean isEditable() {
            return true;
        }

        public void itemEdited(int index, String text) {
            Security newSec;
            Security oldSec;
            String old;
            ILabelProvider provider;
            block12: {
                provider = (ILabelProvider)this.getParent().getColumn(index).getData("labelProvider");
                old = provider.getText((Object)this.watchlistItem);
                if (provider instanceof Symbol) {
                    try {
                        oldSec = this.watchlistItem.getSecurity();
                        newSec = CorePlugin.getRepository().getSecurity(oldSec.getExchange(), oldSec.getMarket(), text.toUpperCase());
                        if (newSec == null) {
                            newSec = CorePlugin.getRepository().getSecurity(text.toUpperCase());
                        }
                        if (newSec != null && !old.equals(newSec) && !this.watchlistItem.getParent().isExists(newSec)) {
                            this.watchlistItem.setSecurity(newSec);
                            this.watchlistItem.setChanged();
                            this.watchlistItem.notifyObservers();
                            break block12;
                        }
                        this.setText(index, old);
                        int i = 0;
                        while (i < WatchlistTableViewer.this.table.getItemCount()) {
                            WatchlistTableItem item;
                            if (WatchlistTableViewer.this.table.getItem(i) instanceof WatchlistTableItem && (item = (WatchlistTableItem)WatchlistTableViewer.this.table.getItem(i)) != null && item.getWatchlistItem() != null && item.getWatchlistItem().getSecurity() != null && newSec != null && item.getWatchlistItem().getSecurity().equals((Object)newSec)) {
                                WatchlistTableViewer.this.table.setSelection((TableItem)item);
                                WatchlistTableViewer.this.updateSelection();
                                break;
                            }
                            ++i;
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (provider instanceof Market) {
                    oldSec = this.watchlistItem.getSecurity();
                    newSec = CorePlugin.getRepository().getSecurity(oldSec.getExchange(), text.toUpperCase(), oldSec.getSymbol());
                    if (newSec == null || old.equals(newSec) || this.watchlistItem.getParent().isExists(newSec)) {
                        this.setText(index, old);
                        return;
                    }
                    this.watchlistItem.setSecurity(newSec);
                    this.watchlistItem.setChanged();
                    this.watchlistItem.notifyObservers();
                    this.watchlistItem.getParent().setMarket(text);
                }
            }
            if (provider instanceof Exchange) {
                oldSec = this.watchlistItem.getSecurity();
                newSec = CorePlugin.getRepository().getSecurity(text.toUpperCase(), oldSec.getMarket(), oldSec.getSymbol());
                if (newSec == null || old.equals(newSec) || this.watchlistItem.getParent().isExists(newSec)) {
                    this.setText(index, old);
                    return;
                }
                this.watchlistItem.setSecurity(newSec);
                this.watchlistItem.setChanged();
                this.watchlistItem.notifyObservers();
                this.watchlistItem.getParent().setExchange(text);
            }
            if (provider != null && provider instanceof IEditableLabelProvider) {
                ((IEditableLabelProvider)provider).setEditableText((Object)this.watchlistItem, text);
            }
            WatchlistTableViewer.this.table.setSelection((TableItem)this);
            WatchlistTableViewer.this.updateSelection();
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
            this.ticker.dispose();
        }
    }

    private class WatchlistTotalsTableItem
    extends TableItem
    implements DisposeListener,
    Observer,
    IEditableItem {
        private WatchlistItem watchlistItem;

        WatchlistTotalsTableItem(Table parent, int style, int index, WatchlistItem watchlistItem) {
            super(parent, style, index);
            this.addDisposeListener(this);
            this.setWatchlistItem(watchlistItem);
        }

        WatchlistTotalsTableItem(Table parent, int style, WatchlistItem watchlistItem) {
            super(parent, style);
            this.addDisposeListener(this);
            this.setWatchlistItem(watchlistItem);
        }

        protected void checkSubclass() {
        }

        void setWatchlistItem(WatchlistItem watchlistItem) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
            this.watchlistItem = watchlistItem;
            this.update();
            this.watchlistItem.addObserver((Observer)this);
        }

        void update() {
            try {
                TableColumn[] columns = this.getParent().getColumns();
                int i = 1;
                while (i < columns.length) {
                    ILabelProvider provider = (ILabelProvider)columns[i].getData("labelProvider");
                    String value = provider.getText((Object)this.watchlistItem.getParent());
                    if (value != null) {
                        Image image;
                        if (!value.equals(this.getText(i))) {
                            this.setText(i, value);
                        }
                        if ((image = provider.getImage((Object)this.watchlistItem.getParent())) != this.getImage(i)) {
                            this.setImage(i, image);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!WatchlistTotalsTableItem.this.isDisposed()) {
                        WatchlistTotalsTableItem.this.update();
                    }
                }
            });
        }

        public boolean canEdit(int index) {
            ILabelProvider provider = (ILabelProvider)this.getParent().getColumn(index).getData("labelProvider");
            if (provider != null && provider instanceof IEditableLabelProvider) {
                return ((IEditableLabelProvider)provider).isEditable((Object)this.watchlistItem.getParent());
            }
            return false;
        }

        public boolean isEditable() {
            return true;
        }

        public void itemEdited(int index, String text) {
            String exchange = "";
            String market = "";
            ILabelProvider provider = (ILabelProvider)this.getParent().getColumn(index).getData("labelProvider");
            if (provider instanceof Symbol) {
                exchange = this.watchlistItem.getParent().getExchange();
                market = this.watchlistItem.getParent().getMarket();
                if ((exchange == null || exchange.length() == 0) && Resources.exchangeNames != null && Resources.exchangeNames.size() > 0) {
                    exchange = "" + Resources.exchangeNames.get(0);
                }
                if ((market == null || market.length() == 0) && Resources.marketTypes != null && Resources.marketTypes.size() > 0) {
                    market = MarketData.marketNames[MarketData.REGULAR];
                }
                if (exchange != null && exchange.length() > 0 && market != null && market.length() > 0 && text != null && text.length() > 0) {
                    Watchlist watchlist;
                    Security security = CorePlugin.getRepository().getSecurity(exchange, market, text);
                    if (security == null) {
                        security = CorePlugin.getRepository().getSecurity(text.toUpperCase());
                    }
                    if (security != null && (watchlist = WatchlistTableViewer.this.getView().getWatchlist()) != null) {
                        if (!watchlist.isExists(security)) {
                            WatchlistItem item = new WatchlistItem();
                            item.setParent(watchlist);
                            item.setSecurity(security);
                            watchlist.getItems().add((Object)item);
                        } else {
                            int i = 0;
                            while (i < WatchlistTableViewer.this.table.getItemCount() - 1) {
                                WatchlistTableItem item = (WatchlistTableItem)WatchlistTableViewer.this.table.getItem(i);
                                if (item.getWatchlistItem().getSecurity().equals((Object)security)) {
                                    WatchlistTableViewer.this.table.setSelection((TableItem)item);
                                    WatchlistTableViewer.this.updateSelection();
                                }
                                ++i;
                            }
                        }
                    }
                    this.setText(index, "");
                }
            }
            if (provider != null && provider instanceof IEditableLabelProvider) {
                ((IEditableLabelProvider)provider).setEditableText((Object)this.watchlistItem.getParent(), text);
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
        }
    }
}

