/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.trading.internal.PatternsSearchPage;

public class WatchlistPatternsSearchPage
extends PatternsSearchPage {
    private Watchlist watchlist;

    public WatchlistPatternsSearchPage(Watchlist watchlist, int period, Date begin, Date end, boolean bullishOnly) {
        super(period, begin, end, bullishOnly);
        this.watchlist = watchlist;
        this.securities = new ArrayList();
        Iterator iter = watchlist.getItems().iterator();
        while (iter.hasNext()) {
            this.securities.add(((WatchlistItem)iter.next()).getSecurity());
        }
    }

    public WatchlistPatternsSearchPage(Watchlist watchlist, IPattern plugin, String name, int period, Date begin, Date end, boolean bullishOnly) {
        super(plugin, name, period, begin, end, bullishOnly);
        this.watchlist = watchlist;
        this.securities = new ArrayList();
        Iterator iter = watchlist.getItems().iterator();
        while (iter.hasNext()) {
            this.securities.add(((WatchlistItem)iter.next()).getSecurity());
        }
    }

    @Override
    public String getDescription() {
        String s = "";
        s = this.patterns.size() == 1 ? String.valueOf(s) + (String)this.patterns.keySet().toArray()[0] + " - " : String.valueOf(s) + "All Patterns - ";
        switch (this.period) {
            case 8: {
                s = String.valueOf(s) + "Daily";
                break;
            }
            case 9: {
                s = String.valueOf(s) + "Weekly";
                break;
            }
            case 10: {
                s = String.valueOf(s) + "Monthly";
            }
        }
        if (this.bullishOnly) {
            s = String.valueOf(s) + " - bullish";
        }
        s = String.valueOf(s) + " - " + String.valueOf(this.results.size()) + " result(s) in " + this.watchlist.getDescription();
        return s;
    }

    @Override
    public String getShortDescription() {
        String s = "";
        s = this.patterns.size() == 1 ? String.valueOf(s) + (String)this.patterns.keySet().toArray()[0] + " - " : String.valueOf(s) + "All Patterns - ";
        switch (this.period) {
            case 8: {
                s = String.valueOf(s) + "Daily";
                break;
            }
            case 9: {
                s = String.valueOf(s) + "Weekly";
                break;
            }
            case 10: {
                s = String.valueOf(s) + "Monthly";
            }
        }
        if (this.bullishOnly) {
            s = String.valueOf(s) + " - bullish";
        }
        s = String.valueOf(s) + " - " + this.watchlist.getDescription();
        return s;
    }
}

