/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.ui.NullSelection;
import pk.com.softech.tradingterminal.core.ui.actions.PropertiesAction;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.WatchlistItemSelection;
import pk.com.softech.tradingterminal.trading.internal.AbstractLayout;
import pk.com.softech.tradingterminal.trading.internal.Box;
import pk.com.softech.tradingterminal.trading.internal.BoxTicker;
import pk.com.softech.tradingterminal.trading.views.WatchlistView;
import pk.com.softech.tradingterminal.trading.wizards.WatchlistItemPropertiesDialog;

public class WatchlistBoxViewer
extends AbstractLayout {
    public static final String FOREGROUND = "BOX_FOREGROUND";
    public static final String BACKGROUND = "BOX_BACKGROUND";
    public static final String POSITIVE_FOREGROUND = "BOX_POSITIVE_FOREGROUND";
    public static final String NEGATIVE_FOREGROUND = "BOX_NEGATIVE_FOREGROUND";
    public static final String BOX_TICK_BACKGROUND = "BOX_TICK_BACKGROUND";
    public static final String BOX_TICK_FOREGROUND = "BOX_TICK_FOREGROUND";
    public static final String RIBBON_WATCH_FONT = "RIBBON_WATCH_FONT";
    private Image up = TradingPlugin.getImageDescriptor("icons/up.gif").createImage();
    private Image down = TradingPlugin.getImageDescriptor("icons/down.gif").createImage();
    private Image equal = TradingPlugin.getImageDescriptor("icons/equal.gif").createImage();
    private Color foreground;
    private Color background;
    private Color negativeForeground;
    private Color positiveForeground;
    private Color tickBackground;
    private Color tickForeground;
    private Font font;
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();
    private NumberFormat numberFormatter = CorePlugin.getNumberFormatter();
    private NumberFormat percentageFormatter = CorePlugin.getPercentageFormatter();
    private Composite content;
    WatchlistItem selectedItem;
    private Action propertiesAction;
    private IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                WatchlistBoxViewer.this.setTheme((ITheme)event.getNewValue());
            } else {
                IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
                ITheme theme = themeManager.getCurrentTheme();
                if (event.getProperty().equals(WatchlistBoxViewer.BACKGROUND)) {
                    WatchlistBoxViewer.this.background = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.FOREGROUND)) {
                    WatchlistBoxViewer.this.foreground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.POSITIVE_FOREGROUND)) {
                    WatchlistBoxViewer.this.positiveForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.NEGATIVE_FOREGROUND)) {
                    WatchlistBoxViewer.this.negativeForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.BOX_TICK_BACKGROUND)) {
                    WatchlistBoxViewer.this.tickBackground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.BOX_TICK_FOREGROUND)) {
                    WatchlistBoxViewer.this.tickForeground = theme.getColorRegistry().get(event.getProperty());
                } else if (event.getProperty().equals(WatchlistBoxViewer.RIBBON_WATCH_FONT)) {
                    WatchlistBoxViewer.this.font = theme.getFontRegistry().get(event.getProperty());
                }
            }
            WatchlistBoxViewer.this.updateView(false);
        }
    };
    MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            Event event = new Event();
            event.display = e.display;
            event.x = e.x;
            event.y = e.y;
            event.widget = WatchlistBoxViewer.this.content;
            event.time = e.time;
            SelectionEvent selection = new SelectionEvent(event);
            WatchlistBoxViewer.this.selectionListener.widgetSelected(selection);
        }

        public void mouseUp(MouseEvent e) {
        }
    };
    SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enable = false;
            WatchlistBoxViewer.this.selectedItem = null;
            if (e.item instanceof BoxViewItem) {
                BoxViewItem viewItem = (BoxViewItem)e.item;
                WatchlistBoxViewer.this.selectedItem = viewItem.getWatchlistItem();
                WatchlistBoxViewer.this.getView().getSite().getSelectionProvider().setSelection((ISelection)new WatchlistItemSelection(WatchlistBoxViewer.this.selectedItem));
                enable = true;
            } else {
                WatchlistBoxViewer.this.getView().getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
            }
            WatchlistBoxViewer.this.getView().fillMenuBars(null);
            IActionBars actionBars = WatchlistBoxViewer.this.getViewSite().getActionBars();
            actionBars.getGlobalActionHandler("cut").setEnabled(enable);
            actionBars.getGlobalActionHandler("copy").setEnabled(enable);
            actionBars.getGlobalActionHandler("delete").setEnabled(enable);
            actionBars.getGlobalActionHandler("properties").setEnabled(enable);
        }
    };

    public WatchlistBoxViewer(WatchlistView view) {
        super(view);
        this.propertiesAction = new PropertiesAction(){

            public void run() {
                WatchlistItem[] selection = WatchlistBoxViewer.this.getSelection();
                if (selection.length != 0 && selection[0] instanceof WatchlistItem) {
                    WatchlistItem item = selection[0];
                    WatchlistItemPropertiesDialog dlg = new WatchlistItemPropertiesDialog(item, WatchlistBoxViewer.this.getViewSite().getShell());
                    dlg.open();
                }
            }
        };
        this.propertiesAction.setEnabled(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("properties", (IAction)this.propertiesAction);
        actionBars.updateActionBars();
    }

    @Override
    public Composite createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = true;
        rowLayout.fill = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        rowLayout.marginLeft = 2;
        rowLayout.marginTop = 2;
        rowLayout.marginRight = 2;
        rowLayout.marginBottom = 2;
        rowLayout.spacing = 3;
        this.content.setLayout((Layout)rowLayout);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
        this.content.addMouseListener(this.mouseListener);
        return this.content;
    }

    @Override
    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        theme.removePropertyChangeListener(this.themeChangeListener);
        if (this.content != null) {
            this.content.dispose();
        }
        this.up.dispose();
        this.down.dispose();
        this.equal.dispose();
    }

    @Override
    public void updateView(boolean ignoreSorting) {
        this.content.setRedraw(false);
        Control[] items = this.content.getChildren();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        for (WatchlistItem watchlistItem : this.getView().getWatchlist().getItems()) {
            BoxViewItem viewItem = new BoxViewItem(this.content, 0, watchlistItem);
            viewItem.setBackground(this.background);
            viewItem.setForeground(this.foreground);
            viewItem.setPositiveForeground(this.positiveForeground);
            viewItem.setNegativeForeground(this.negativeForeground);
            viewItem.ticker.setForeground(this.tickForeground);
            viewItem.ticker.setBackground(this.tickBackground);
            viewItem.setFont(this.font);
        }
        this.content.setRedraw(true);
        this.content.layout(true, true);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.content.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!WatchlistBoxViewer.this.content.isDisposed()) {
                    WatchlistBoxViewer.this.updateView(false);
                }
            }
        });
    }

    @Override
    public void itemAdded(Object o) {
        if (o instanceof WatchlistItem) {
            WatchlistItem watchlistItem = (WatchlistItem)o;
            BoxViewItem viewItem = new BoxViewItem(this.content, 0, watchlistItem);
            viewItem.setBackground(this.background);
            viewItem.setForeground(this.foreground);
            viewItem.setPositiveForeground(this.positiveForeground);
            viewItem.setNegativeForeground(this.negativeForeground);
            viewItem.setFont(this.font);
            this.content.layout(true, true);
        }
    }

    @Override
    public void itemRemoved(final Object o) {
        if (this.content != null && !this.content.isDisposed()) {
            this.content.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control[] items = WatchlistBoxViewer.this.content.getChildren();
                    int i = 0;
                    while (i < items.length) {
                        BoxViewItem tableItem = (BoxViewItem)items[i];
                        if (tableItem.getWatchlistItem().equals(o)) {
                            tableItem.dispose();
                            WatchlistBoxViewer.this.content.layout();
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    @Override
    public int getItemIndex(Point point) {
        return -1;
    }

    protected void setTheme(ITheme theme) {
        this.positiveForeground = theme.getColorRegistry().get(POSITIVE_FOREGROUND);
        this.negativeForeground = theme.getColorRegistry().get(NEGATIVE_FOREGROUND);
        this.foreground = theme.getColorRegistry().get(FOREGROUND);
        this.background = theme.getColorRegistry().get(BACKGROUND);
        this.tickBackground = theme.getColorRegistry().get(BOX_TICK_BACKGROUND);
        this.tickForeground = theme.getColorRegistry().get(BOX_TICK_FOREGROUND);
        this.font = theme.getFontRegistry().get(RIBBON_WATCH_FONT);
        theme.addPropertyChangeListener(this.themeChangeListener);
    }

    @Override
    public WatchlistItem[] getSelection() {
        if (this.selectedItem != null) {
            return new WatchlistItem[]{this.selectedItem};
        }
        return new WatchlistItem[0];
    }

    public class BoxViewItem
    extends Box
    implements DisposeListener,
    Observer {
        private WatchlistItem watchlistItem;
        private MenuManager menuMgr;
        private BoxTicker ticker;

        public BoxViewItem(Composite parent, int style, WatchlistItem watchlistItem) {
            super(parent, style);
            this.addDisposeListener(this);
            this.setWatchlistItem(watchlistItem);
            this.addSelectionListener((SelectionListener)WatchlistBoxViewer.this.selectionListener);
            this.ticker = new BoxTicker(this, 3);
            this.ticker.setBackground(WatchlistBoxViewer.this.tickBackground);
            this.ticker.setForeground(WatchlistBoxViewer.this.tickForeground);
            this.menuMgr = new MenuManager("#popupMenu", "popupMenu");
            this.menuMgr.setRemoveAllWhenShown(true);
            this.menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuManager) {
                    WatchlistBoxViewer.this.getView().fillMenuBars(menuManager);
                    menuManager.add((IContributionItem)new Separator("top"));
                    menuManager.add((IContributionItem)new Separator("group0"));
                    menuManager.add((IContributionItem)new Separator("group1"));
                    menuManager.add((IContributionItem)new Separator("group2"));
                    menuManager.add((IContributionItem)new Separator("group3"));
                    menuManager.add((IContributionItem)new Separator("group4"));
                    menuManager.add((IContributionItem)new Separator("group5"));
                    menuManager.add((IContributionItem)new Separator("news"));
                    menuManager.add((IContributionItem)new Separator("search"));
                    menuManager.add((IContributionItem)new Separator("additions"));
                    menuManager.add((IContributionItem)new Separator("bottom"));
                    menuManager.add((IAction)WatchlistBoxViewer.this.propertiesAction);
                }
            });
            WatchlistBoxViewer.this.getView().getSite().registerContextMenu(this.menuMgr, WatchlistBoxViewer.this.getView().getSite().getSelectionProvider());
            this.setMenu(this.menuMgr.createContextMenu((Control)this));
        }

        WatchlistItem getWatchlistItem() {
            return this.watchlistItem;
        }

        void setWatchlistItem(WatchlistItem watchlistItem) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
            this.watchlistItem = watchlistItem;
            this.updateDisplay(false);
            this.watchlistItem.addObserver((Observer)this);
        }

        private void updateDisplay(boolean tick) {
            Security security = this.watchlistItem.getSecurity();
            this.setName(security.getId());
            this.setToolTip(this.watchlistItem.getSecurity().getDescription());
            Quote quote = security.getQuote();
            if (quote != null) {
                double currentIndex = 0.0;
                currentIndex = security.getCurrentIndex();
                if (!this.watchlistItem.getParent().isUseDefaultCurrency()) {
                    currentIndex = CurrencyConverter.getInstance().convert(security.getCurrentIndex(), security.getCurrency(), this.watchlistItem.getParent().getCurrency());
                }
                this.setCurrentIndex(WatchlistBoxViewer.this.priceFormatter.format(currentIndex));
                if (security.getChange() != null) {
                    double change = security.getChange();
                    if (!this.watchlistItem.getParent().isUseDefaultCurrency()) {
                        change = CurrencyConverter.getInstance().convert(change, security.getCurrency(), this.watchlistItem.getParent().getCurrency());
                    }
                    double percentage = security.getChangePerc();
                    if (change > 0.0) {
                        this.setChange("+" + WatchlistBoxViewer.this.priceFormatter.format(change) + " (+" + WatchlistBoxViewer.this.percentageFormatter.format(percentage) + ")");
                    } else if (change < 0.0) {
                        this.setChange(String.valueOf(WatchlistBoxViewer.this.priceFormatter.format(change)) + " (" + WatchlistBoxViewer.this.percentageFormatter.format(percentage) + ")");
                    } else {
                        this.setChange(String.valueOf(WatchlistBoxViewer.this.priceFormatter.format(change)) + " (" + WatchlistBoxViewer.this.percentageFormatter.format(percentage) + ")");
                    }
                }
                quote.getDate();
                this.setTurnover(WatchlistBoxViewer.this.numberFormatter.format(security.getTotalTurnover()));
                if (tick) {
                    this.ticker.tick();
                }
            }
            this.getParent().layout(true, true);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BoxViewItem.this.isDisposed()) {
                        BoxViewItem.this.updateDisplay(true);
                    }
                }
            });
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.watchlistItem != null) {
                this.watchlistItem.deleteObserver((Observer)this);
            }
            if (this.menuMgr != null) {
                this.menuMgr.dispose();
            }
        }
    }
}

