/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import pk.com.softech.tradingterminal.core.db.Level2;

public class Trendbar
extends Canvas
implements DisposeListener,
PaintListener {
    private int[] bidQuantity = new int[5];
    private int[] askQuantity = new int[5];
    private Color indicator;
    private Color[] band = new Color[5];

    public Trendbar(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
        this.addDisposeListener(this);
    }

    public void setData(Level2 bid, Level2 ask) {
        Iterator iter;
        int index = 0;
        if (bid != null && bid.size() > 0) {
            iter = bid.getGrouped().iterator();
            while (iter.hasNext() && index < 5) {
                this.bidQuantity[index] = ((Level2.Item)iter.next()).quantity;
                ++index;
            }
        }
        while (index < 5) {
            this.bidQuantity[index++] = 0;
        }
        index = 0;
        if (ask != null && ask.size() > 0) {
            iter = ask.getGrouped().iterator();
            while (iter.hasNext() && index < 5) {
                this.askQuantity[index] = ((Level2.Item)iter.next()).quantity;
                ++index;
            }
        }
        while (index < 5) {
            this.askQuantity[index++] = 0;
        }
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        int middle = 3;
        int width = this.getClientArea().width - 3;
        int height = this.getClientArea().height;
        double total = 0.0;
        int i = 0;
        while (i < this.bidQuantity.length) {
            total += (double)this.bidQuantity[i];
            ++i;
        }
        i = 0;
        while (i < this.askQuantity.length) {
            total += (double)this.askQuantity[i];
            ++i;
        }
        if (total == 0.0) {
            return;
        }
        int last = this.getClientArea().width - middle;
        int[] bidWidth = new int[5];
        int i2 = 0;
        while (i2 < this.bidQuantity.length) {
            bidWidth[i2] = (int)((double)width / total * (double)this.bidQuantity[i2]);
            last -= bidWidth[i2];
            ++i2;
        }
        int[] askWidth = new int[5];
        int i3 = 0;
        while (i3 < this.askQuantity.length - 1) {
            askWidth[i3] = (int)((double)width / total * (double)this.askQuantity[i3]);
            last -= askWidth[i3];
            ++i3;
        }
        askWidth[4] = last;
        int x = 0;
        int i4 = bidWidth.length - 1;
        while (i4 >= 0) {
            e.gc.setBackground(this.band[i4]);
            e.gc.fillRectangle(x, 0, bidWidth[i4], height);
            x += bidWidth[i4];
            --i4;
        }
        e.gc.setBackground(this.indicator);
        e.gc.fillRectangle(x, 0, middle, height);
        x += middle;
        i4 = 0;
        while (i4 < askWidth.length && i4 < 5) {
            e.gc.setBackground(this.band[i4]);
            e.gc.fillRectangle(x, 0, askWidth[i4], height);
            x += askWidth[i4];
            ++i4;
        }
    }

    public void setBandColors(Color[] colors) {
        int i = 0;
        while (i < this.band.length) {
            if (this.band[i] != null && !this.band[i].isDisposed()) {
                this.band[i].dispose();
            }
            ++i;
        }
        i = 0;
        while (i < this.band.length && i < colors.length) {
            this.band[i] = new Color(null, colors[i].getRGB());
            ++i;
        }
    }

    public void setBandColor(int index, Color color) {
        if (this.band[index] != null && !this.band[index].isDisposed()) {
            this.band[index].dispose();
        }
        this.band[index] = new Color(null, color.getRGB());
    }

    public void setIndicatorColor(Color color) {
        if (this.indicator != null && !this.indicator.isDisposed()) {
            this.indicator.dispose();
        }
        this.indicator = new Color(null, color.getRGB());
    }

    public void widgetDisposed(DisposeEvent e) {
        int i = 0;
        while (i < this.band.length) {
            if (this.band[i] != null && !this.band[i].isDisposed()) {
                this.band[i].dispose();
            }
            ++i;
        }
    }
}

