/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.Quote;

public class SimpleAccount
extends Account {
    public static final String PLUGIN_ID = "pk.com.softech.tradingterminal.accounts.simple";
    public static final String PREFS_FIXEDCOMMISSIONS = "fixedCommissions";
    public static final String PREFS_VARIABLECOMMISSIONS = "variableCommissions";
    public static final String PREFS_MINIMUMCOMMISSION = "minimumCommission";
    public static final String PREFS_MAXIMUMCOMMISSION = "maximumCommission";

    public SimpleAccount() {
        this.setPluginId(PLUGIN_ID);
    }

    public SimpleAccount(String id) {
        super(id);
        this.setPluginId(PLUGIN_ID);
    }

    protected SimpleAccount(Account account) {
        super(account);
    }

    public double getFixedCommissions() {
        return this.getPreferenceStore().getDouble(PREFS_FIXEDCOMMISSIONS);
    }

    public double getVariableCommissions() {
        return this.getPreferenceStore().getDouble(PREFS_VARIABLECOMMISSIONS);
    }

    public double getMaximumCommission() {
        return this.getPreferenceStore().getDouble(PREFS_MAXIMUMCOMMISSION);
    }

    public double getMinimumCommission() {
        return this.getPreferenceStore().getDouble(PREFS_MINIMUMCOMMISSION);
    }

    public double getExpenses(Security security, int quantity, double price) {
        Quote quote;
        double expenses = this.getFixedCommissions();
        if (security != null && (quote = security.getQuote()) != null) {
            double value = (double)Math.abs(quantity) * quote.getLast();
            expenses += value / 100.0 * this.getVariableCommissions();
        }
        if (expenses < this.getMinimumCommission()) {
            expenses = this.getMinimumCommission();
        }
        if (this.getMaximumCommission() != 0.0 && expenses > this.getMaximumCommission()) {
            expenses = this.getMaximumCommission();
        }
        return expenses;
    }

    public Object clone() throws CloneNotSupportedException {
        return new SimpleAccount(this);
    }
}

