/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.Date;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.trading.internal.PatternsSearchPage;

public class SecurityPatternsSearchPage
extends PatternsSearchPage {
    private Security security;

    public SecurityPatternsSearchPage(Security security, int period, Date begin, Date end, boolean bullishOnly) {
        super(period, begin, end, bullishOnly);
        this.security = security;
        this.securities = new ArrayList();
        this.securities.add(security);
    }

    public SecurityPatternsSearchPage(Security security, IPattern plugin, String name, int period, Date begin, Date end, boolean bullishOnly) {
        super(plugin, name, period, begin, end, bullishOnly);
        this.security = security;
        this.securities = new ArrayList();
        this.securities.add(security);
    }

    @Override
    public String getDescription() {
        String s = "";
        s = this.patterns.size() == 1 ? String.valueOf(s) + (String)this.patterns.keySet().toArray()[0] + " - " : String.valueOf(s) + "All Patterns - ";
        switch (this.period) {
            case 8: {
                s = String.valueOf(s) + "Daily";
                break;
            }
            case 9: {
                s = String.valueOf(s) + "Weekly";
                break;
            }
            case 10: {
                s = String.valueOf(s) + "Monthly";
            }
        }
        if (this.bullishOnly) {
            s = String.valueOf(s) + " - bullish";
        }
        s = String.valueOf(s) + " - " + String.valueOf(this.results.size()) + " result(s) in " + this.security.getDescription();
        return s;
    }

    @Override
    public String getShortDescription() {
        String s = "";
        s = this.patterns.size() == 1 ? String.valueOf(s) + (String)this.patterns.keySet().toArray()[0] + " - " : String.valueOf(s) + "All Patterns - ";
        switch (this.period) {
            case 8: {
                s = String.valueOf(s) + "Daily";
                break;
            }
            case 9: {
                s = String.valueOf(s) + "Weekly";
                break;
            }
            case 10: {
                s = String.valueOf(s) + "Monthly";
            }
        }
        if (this.bullishOnly) {
            s = String.valueOf(s) + " - bullish";
        }
        s = String.valueOf(s) + " - " + this.security.getDescription();
        return s;
    }
}

