/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IPattern;
import pk.com.softech.tradingterminal.core.Sentiment;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.BarData;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.trading.views.IPatternSearchPage;
import pk.com.softech.tradingterminal.trading.views.PatternSearchItem;

public abstract class PatternsSearchPage
implements IPatternSearchPage {
    protected List securities = new ArrayList();
    protected int period;
    protected boolean bullishOnly;
    protected Date begin;
    protected Date end;
    protected boolean allOccurrences = false;
    protected Map patterns = new HashMap();
    protected List results = new ArrayList();

    public PatternsSearchPage(int period, Date begin, Date end, boolean bullishOnly) {
        this.period = period;
        this.bullishOnly = bullishOnly;
        this.begin = begin;
        this.end = end;
        for (IConfigurationElement element : CorePlugin.getAllPatternPlugins()) {
            IPattern plugin = CorePlugin.createPatternPlugin((String)element.getAttribute("id"));
            this.patterns.put(element.getAttribute("name"), plugin);
        }
    }

    public PatternsSearchPage(IPattern plugin, String name, int period, Date begin, Date end, boolean bullishOnly) {
        this.period = period;
        this.bullishOnly = bullishOnly;
        this.begin = begin;
        this.end = end;
        this.patterns.put(name, plugin);
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getShortDescription();

    @Override
    public void run(IProgressMonitor monitor) {
        this.getResults().clear();
        monitor.beginTask("Searching", this.securities.size());
        for (Security security : this.securities) {
            BarData barData = new BarData(security.getHistory().getList(), this.begin, this.end);
            if (this.period != 8) {
                barData = barData.getCompressed(this.period);
            }
            HashMap<IPattern, Date> lastComplete = new HashMap<IPattern, Date>();
            for (String name : this.patterns.keySet()) {
                IPattern pattern = (IPattern)this.patterns.get(name);
                pattern.init(security);
                int i = 0;
                while (i < barData.size()) {
                    pattern.add(barData.get(i));
                    if (pattern.getSentiment().equals((Object)Sentiment.BULLISH) || pattern.getSentiment().equals((Object)Sentiment.BEARISH)) {
                        Bar complete = barData.get(i);
                        Date last = (Date)lastComplete.get(pattern);
                        if (last == null || !last.equals(complete.getDate())) {
                            PatternSearchItem item = new PatternSearchItem();
                            item.setCode(security.getSymbol());
                            item.setDescription(security.getDescription());
                            item.setDate(complete.getDate());
                            item.setPrice(complete.getClose());
                            item.setPattern(name);
                            item.setOpportunity(pattern.getSentiment().equals((Object)Sentiment.BULLISH) ? "Bullish" : "Bearish");
                            if (!this.allOccurrences) {
                                PatternSearchItem[] items = this.getResults().toArray(new PatternSearchItem[0]);
                                int x = 0;
                                while (x < items.length) {
                                    if (items[x].getCode().equals(item.getCode()) && items[x].getDescription().equals(item.getDescription()) && items[x].getPattern().equals(item.getPattern())) {
                                        this.getResults().remove(items[x]);
                                    }
                                    ++x;
                                }
                            }
                            this.getResults().add(item);
                            lastComplete.put(pattern, complete.getDate());
                        }
                    }
                    ++i;
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    @Override
    public List getResults() {
        return this.results;
    }

    public void setAllOccurrences(boolean allOccurrences) {
        this.allOccurrences = allOccurrences;
    }
}

