/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.internal;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class OrdersCleanupJob
extends Job {
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public OrdersCleanupJob() {
        super("Orders Cleanup");
    }

    protected IStatus run(IProgressMonitor monitor) {
        IPreferenceStore preferences = TradingPlugin.getDefault().getPreferenceStore();
        this.log.debug((Object)"Start orders cleanup");
        Date today = Calendar.getInstance().getTime();
        Order[] orders = (Order[])CorePlugin.getRepository().allOrders().toArray((Object[])new Order[0]);
        int i = 0;
        while (i < orders.length) {
            long diff;
            if (orders[i].getStatus().equals((Object)OrderStatus.CANCELED) || orders[i].getStatus().equals((Object)OrderStatus.REJECTED)) {
                diff = (today.getTime() - orders[i].getDate().getTime()) / 86400000L;
                if (preferences.getBoolean("DELETE_CANCELED_ORDERS") && diff >= (long)preferences.getInt("DELETE_CANCELED_ORDERS_DAYS")) {
                    if (orders[i].getProvider() != null) {
                        this.log.info((Object)("Deleting order " + CorePlugin.getPluginName((String)"pk.com.softech.tradingterminal.core.tradingProviders", (String)orders[i].getPluginId()) + " / " + orders[i].getOrderId()));
                    } else {
                        this.log.info((Object)("Deleting order " + orders[i].getOrderId()));
                    }
                    CorePlugin.getRepository().delete((PersistentObject)orders[i]);
                }
            } else if (orders[i].getStatus().equals((Object)OrderStatus.FILLED)) {
                diff = (today.getTime() - orders[i].getDate().getTime()) / 86400000L;
                if (preferences.getBoolean("DELETE_FILLED_ORDERS") && diff >= (long)preferences.getInt("DELETE_FILLED_ORDERS_DAYS")) {
                    if (orders[i].getProvider() != null) {
                        this.log.info((Object)("Deleting order " + CorePlugin.getPluginName((String)"pk.com.softech.tradingterminal.core.tradingProviders", (String)orders[i].getPluginId()) + " / " + orders[i].getOrderId()));
                    } else {
                        this.log.info((Object)("Deleting order " + orders[i].getOrderId()));
                    }
                    CorePlugin.getRepository().delete((PersistentObject)orders[i]);
                }
            }
            ++i;
        }
        this.log.debug((Object)"Orders cleanup completed");
        return Status.OK_STATUS;
    }
}

